{******************************************************************************}
{ FileName............: MajorDvbSetupCard                                      }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 0.02                                                   }
{------------------------------------------------------------------------------}
{  Card / Hardware options                                                     }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Version   Date   Comment                                                     }
{  0.01   20041019 - Initial release                                           }
{  0.02   20050410 - FlexCop added                                             }
{******************************************************************************}
unit MajorDvbSetupCard;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TfrmSetupCard = class(TForm)
    rgCard: TRadioGroup;
    rgTuner: TRadioGroup;
    btnOK: TButton;
    btnDiscard: TButton;
    rgTunerReset: TRadioGroup;
    rgPolarity: TRadioGroup;
    rgLnbPower: TRadioGroup;
    rgSynthesizerAddress: TRadioGroup;
    Shape1: TShape;
    Shape2: TShape;
    gbMiscellaneous: TGroupBox;
    Label1: TLabel;
    cmbThreadPriority: TComboBox;
    cmbCardNumber: TComboBox;
    Label2: TLabel;
    Label3: TLabel;
    cmbRpsProgram: TComboBox;
    rgMasterMode: TRadioGroup;
    Label4: TLabel;
    cmbBufferSize: TComboBox;
    Shape3: TShape;
    Shape4: TShape;
    Shape5: TShape;
    btnRevert: TButton;
    procedure btnOKClick(Sender: TObject);
    procedure btnDiscardClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure rgCardClick(Sender: TObject);
    procedure rgPolarityClick(Sender: TObject);
    procedure rgLnbPowerClick(Sender: TObject);
    procedure btnRevertClick(Sender: TObject);
  private
    { Private declarations }
    FOrgCardNumber        : Integer;
    FOrgCard              : Integer;
    FOrgTuner             : Integer;
    FOrgSynthesizerAddress: Integer;
    FOrgPolarity          : Integer;
    FOrgTunerReset        : Integer;
    FOrgLnbPower          : Integer;
    FOrgThreadPriority    : Integer;
    FOrgRpsProgram        : Integer;
    FOrgBufferSize        : Integer;
    FOrgMasterMode        : Integer;
    FExitCallback         : TNotifyEvent;
    FAccepted             : Boolean;
    function  GetCardNumber        : Integer;
    procedure SetCardNumber        (Value: Integer);
    function  GetCard              : Integer;
    procedure SetCard              (Value: Integer);
    function  GetTuner             : Integer;
    procedure SetTuner             (Value: Integer);
    function  GetSynthesizerAddress: Integer;
    procedure SetSynthesizerAddress(Value: Integer);
    function  GetPolarity          : Integer;
    procedure SetPolarity          (Value: Integer);
    function  GetTunerReset        : Integer;
    procedure SetTunerReset        (Value: Integer);
    function  GetLnbPower          : Integer;
    procedure SetLnbPower          (Value: Integer);
    function  GetThreadPriority    : Integer;
    procedure SetThreadPriority    (Value: Integer);
    function  GetRpsProgram        : Integer;
    procedure SetRpsProgram        (Value: Integer);
    function  GetBufferSize        : Integer;
    procedure SetBufferSize        (Value: Integer);
    function  GetMasterMode        : Integer;
    procedure SetMasterMode        (Value: Integer);
    function  GetCardName          : string;
    procedure SetCardName          (Value: string);
    function  GetTunerName         : string;
    procedure SetTunerName         (Value: string);
    function  GetPriorityName      : string;
    procedure SetPriorityName      (Value: string);
    procedure Revert;
    function  GetSettingChanged    : Boolean;
  public
    { Public declarations }
    property CardNumber         : Integer      read GetCardNumber         write SetCardNumber;
    property Card               : Integer      read GetCard               write SetCard;
    property Tuner              : Integer      read GetTuner              write SetTuner;
    property SynthesizerAddress : Integer      read GetSynthesizerAddress write SetSynthesizerAddress;
    property Polarity           : Integer      read GetPolarity           write SetPolarity;
    property TunerReset         : Integer      read GetTunerReset         write SetTunerReset;
    property LnbPower           : Integer      read GetLnbPower           write SetLnbPower;
    property ThreadPriority     : Integer      read GetThreadPriority     write SetThreadPriority;
    property RpsProgram         : Integer      read GetRpsProgram         write SetRpsProgram;
    property BufferSize         : Integer      read GetBufferSize         write SetBufferSize;
    property MasterMode         : Integer      read GetMasterMode         write SetMasterMode;
    property CardName           : string       read GetCardName           write SetCardName;
    property TunerName          : string       read GetTunerName          write SetTunerName;
    property PriorityName       : string       read GetPriorityName       write SetPriorityName;
    property ExitNotify         : TNotifyEvent read FExitCallback         write FExitCallback;
    property SettingChanged     : Boolean      read GetSettingChanged;
    property Accepted           : Boolean      read FAccepted;
  end;

implementation

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>  True if a setting has changed

  Descript: Get flag if a setting has changed
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmSetupCard.GetSettingChanged: Boolean;
begin
  Result := False;
  Result := Result or (cmbCardNumber.ItemIndex        <> FOrgCardNumber);
  Result := Result or (rgCard.ItemIndex               <> FOrgCard);
  Result := Result or (rgTuner.ItemIndex              <> FOrgTuner);
  Result := Result or (rgSynthesizerAddress.ItemIndex <> FOrgSynthesizerAddress);
  Result := Result or (rgTunerReset.ItemIndex         <> FOrgTunerReset);
  Result := Result or (rgLnbPower.ItemIndex           <> FOrgLnbPower);
  Result := Result or (cmbThreadPriority.ItemIndex    <> FOrgThreadPriority);
  Result := Result or (cmbRpsProgram.ItemIndex        <> FOrgRpsProgram);
  Result := Result or (cmbBufferSize.ItemIndex        <> FOrgBufferSize);
  Result := Result or (rgMasterMode.ItemIndex         <> FOrgMasterMode);
end;


function TfrmSetupCard.GetCardNumber: Integer;
begin
  Result := cmbCardNumber.ItemIndex - 1;
end;


procedure TfrmSetupCard.SetCardNumber(Value: Integer);
begin
  Value := Value + 1;
  if Value < 0 then
    Value := 0;
  if Value > (cmbCardNumber.Items.Count-1) then
    Value := (cmbCardNumber.Items.Count-1);
  cmbCardNumber.ItemIndex := Value;
  FOrgCardNumber := Value;
end;


function TfrmSetupCard.GetCard: Integer;
begin
  if (rgCard.ItemIndex < 0) or (rgCard.ItemIndex >= (rgCard.Items.Count-1)) then
    Result := 255
  else
    Result := rgCard.ItemIndex;
end;


procedure TfrmSetupCard.SetCard(Value: Integer);
begin
  if (Value < -1) or (Value > (rgCard.Items.Count-1)) then
    Value := rgCard.Items.Count-1;
  rgCard.ItemIndex := Value;
  FOrgCard         := Value;
end;


function TfrmSetupCard.GetTuner: Integer;
begin
  if (rgTuner.ItemIndex < 0) or (rgTuner.ItemIndex > (rgTuner.Items.Count-1)) then
    Result := 255
  else
    Result := rgTuner.ItemIndex;
end;


procedure TfrmSetupCard.SetTuner(Value: Integer);
begin
  if (Value < -1) or (Value > (rgTuner.Items.Count-1)) then
    Value := 0;
  rgTuner.ItemIndex := Value;
  FOrgTuner         := Value;
end;

function TfrmSetupCard.GetSynthesizerAddress: Integer;
begin
  if (rgSynthesizerAddress.ItemIndex < 0) or (rgSynthesizerAddress.ItemIndex > (rgSynthesizerAddress.Items.Count-1)) then
    Result := 255
  else
    Result := rgSynthesizerAddress.ItemIndex;
end;


procedure TfrmSetupCard.SetSynthesizerAddress(Value: Integer);
begin
  if (Value < -1) or (Value > (rgSynthesizerAddress.Items.Count-1)) then
    Value := 0;
  rgSynthesizerAddress.ItemIndex := Value;
  FOrgSynthesizerAddress         := Value;
end;


function TfrmSetupCard.GetPolarity: Integer;
begin
  if (rgPolarity.ItemIndex < 0) or (rgPolarity.ItemIndex >= (rgPolarity.Items.Count-1)) then
    Result := 255
  else
    Result := rgPolarity.ItemIndex;
end;


procedure TfrmSetupCard.SetPolarity(Value: Integer);
begin
  if (Value < -1) or (Value > (rgPolarity.Items.Count-1)) then
    Value := rgPolarity.Items.Count-1;
  rgPolarity.ItemIndex := Value;
  FOrgPolarity         := Value;
end;


function TfrmSetupCard.GetTunerReset: Integer;
begin
  if (rgTunerReset.ItemIndex < 0) or (rgTunerReset.ItemIndex >= (rgTunerReset.Items.Count-1)) then
    Result := 255
  else
    Result := rgTunerReset.ItemIndex;
end;


procedure TfrmSetupCard.SetTunerReset(Value: Integer);
begin
  if (Value < -1) or (Value > (rgTunerReset.Items.Count-1)) then
    Value := rgTunerReset.Items.Count-1;
  rgTunerReset.ItemIndex := Value;
  FOrgTunerReset         := Value;
end;


function TfrmSetupCard.GetLnbPower: Integer;
begin
  if (rgLnbPower.ItemIndex < 0) or (rgLnbPower.ItemIndex >= (rgLnbPower.Items.Count-1)) then
    Result := 255
  else
    Result := rgLnbPower.ItemIndex;
end;


procedure TfrmSetupCard.SetLnbPower(Value: Integer);
begin
  if (Value < -1) or (Value > (rgLnbPower.Items.Count-1)) then
    Value := rgLnbPower.Items.Count-1;
  rgLnbPower.ItemIndex := Value;
  FOrgLnbPower := Value;
end;


function TfrmSetupCard.GetThreadPriority: Integer;
begin
  Result := cmbThreadPriority.ItemIndex;
end;


procedure TfrmSetupCard.SetThreadPriority(Value: Integer);
begin
  if Value < 0 then
    Value := 0;
  if Value > (cmbThreadPriority.Items.Count-1) then
    Value := cmbThreadPriority.Items.Count-1;
  cmbThreadPriority.ItemIndex := Value;
  FOrgThreadPriority          := Value;
end;


function TfrmSetupCard.GetRpsProgram: Integer;
begin
  Result := cmbRpsProgram.ItemIndex - 2;
end;


procedure TfrmSetupCard.SetRpsProgram(Value: Integer);
begin
  Value := Value + 2;
  if Value < 0 then
    Value := 0;
  if Value > (cmbRpsProgram.Items.Count-1) then
    Value := cmbRpsProgram.Items.Count-1;
  cmbRpsProgram.ItemIndex := Value;
  FOrgRpsProgram          := Value;
end;


function TfrmSetupCard.GetBufferSize: Integer;
begin
  Result := (cmbBufferSize.ItemIndex + 1) * 100;
end;


procedure TfrmSetupCard.SetBufferSize(Value: Integer);
begin
  Value := Value div 100;
  Value := Value - 1;
  if Value < 0 then
    Value := 0;
  if Value > (cmbBufferSize.Items.Count-1) then
    Value := cmbBufferSize.Items.Count-1;
  cmbBufferSize.ItemIndex := Value;
  FOrgBufferSize          := Value;
end;


function TfrmSetupCard.GetMasterMode: Integer;
begin
  Result := rgMasterMode.ItemIndex;
end;


procedure TfrmSetupCard.SetMasterMode(Value: Integer);
begin
  if Value < 0 then
    Value := 0;
  if Value > (rgMasterMode.Items.Count-1) then
    Value := rgMasterMode.Items.Count-1;
  rgMasterMode.ItemIndex := Value;
  FOrgMasterMode          := Value;
end;


function TfrmSetupCard.GetCardName: string;
begin
  case rgCard.ItemIndex of
   -1: Result := 'Undefined';
    0: Result := 'TTPClineBudget';
    1: Result := 'TTPClineBudget2';
    2: Result := 'Nova';
    3: Result := 'Nova2';
    4: Result := 'Terratec';
    5: Result := 'KNC';
    6: Result := 'Typhoon';
    7: Result := 'Anubis';
    8: Result := 'Satelco';
    9: Result := 'FlexCop';
    10: Result := 'None';
    else Result := '';
  end;
end;


procedure TfrmSetupCard.SetCardName(Value: string);
begin
  Value := UpperCase(Value);
  // Default to 'user defined'
  rgCard.ItemIndex := rgCard.Items.Count - 1;
  if Value = UpperCase('TTPClineBudget') then
    rgCard.ItemIndex := 0;
  if Value = UpperCase('TTPClineBudget2') then
    rgCard.ItemIndex := 1;
  if Value = UpperCase('Nova') then
    rgCard.ItemIndex := 2;
  if Value = UpperCase('Nova2') then
    rgCard.ItemIndex := 3;
  if Value = UpperCase('Terratec') then
    rgCard.ItemIndex := 4;
  if Value = UpperCase('KNC') then
    rgCard.ItemIndex := 5;
  if Value = UpperCase('Typhoon') then
    rgCard.ItemIndex := 6;
  if Value = UpperCase('Anubis') then
    rgCard.ItemIndex := 7;
  if Value = UpperCase('Satelco') then
    rgCard.ItemIndex := 8;
  if Value = UpperCase('FlexCop') then
    rgCard.ItemIndex := 9;
  if Value = UpperCase('None') then
    rgCard.ItemIndex := 10;
  ForgCard := rgCard.ItemIndex;
end;


function TfrmSetupCard.GetTunerName: string;
begin
  case rgTuner.ItemIndex of
    0: Result := 'BSRU6';
    1: Result := 'SU1278';
    2: Result := 'BSBE1';
    else Result := '';
  end;
end;


procedure TfrmSetupCard.SetTunerName(Value: string);
begin
  Value := UpperCase(Value);
  // Default to 'user defined'
  rgTuner.ItemIndex := 0;
  if Value = 'BSRU6' then
    rgTuner.ItemIndex := 0;
  if Value = 'SU1278' then
    rgTuner.ItemIndex := 1;
  if Value = 'BSBE1' then
    rgTuner.ItemIndex := 2;
  ForgTuner := rgTuner.ItemIndex;
end;


function TfrmSetupCard.GetPriorityName: string;
begin
  case cmbThreadPriority.ItemIndex of
    0: Result := 'Lowest';
    1: Result := 'Low';
    2: Result := 'Normal';
    3: Result := 'Default';
    4: Result := 'High';
    5: Result := 'Highest';
    6: Result := 'Realtime';
    else Result := '';
  end;
end;


procedure TfrmSetupCard.SetPriorityName(Value: string);
begin
  Value := UpperCase(Value);
  // Default to 'default'
  cmbThreadPriority.ItemIndex := 3;
  if Value = UpperCase('Lowest') then
    cmbThreadPriority.ItemIndex := 0;
  if Value = UpperCase('Low') then
    cmbThreadPriority.ItemIndex := 1;
  if Value = UpperCase('Normal') then
    cmbThreadPriority.ItemIndex := 2;
  if Value = UpperCase('Default') then
    cmbThreadPriority.ItemIndex := 3;
  if Value = UpperCase('High') then
    cmbThreadPriority.ItemIndex := 4;
  if Value = UpperCase('Highest') then
    cmbThreadPriority.ItemIndex := 5;
  if Value = UpperCase('Realtime') then
    cmbThreadPriority.ItemIndex := 6;
  FOrgThreadPriority := cmbThreadPriority.ItemIndex;
end;


procedure TfrmSetupCard.Revert;
begin
  cmbCardNumber.ItemIndex        := FOrgCardNumber;
  rgCard.ItemIndex               := FOrgCard;
  rgTuner.ItemIndex              := FOrgTuner;
  rgSynthesizerAddress.ItemIndex := FOrgSynthesizerAddress;
  rgPolarity.ItemIndex           := FOrgPolarity;
  rgTunerReset.ItemIndex         := FOrgTunerReset;
  rgLnbPower.ItemIndex           := FOrgLnbPower;
  cmbThreadPriority.ItemIndex    := FOrgThreadPriority;
  cmbRpsProgram.ItemIndex        := FOrgRpsProgram;
  cmbBufferSize.ItemIndex        := FOrgBufferSize;
  rgMasterMode.ItemIndex         := FOrgMasterMode;
end;


procedure TfrmSetupCard.rgCardClick(Sender: TObject);
  procedure SetOptions(Enabled: Boolean);
  begin
    rgTuner.Enabled              := Enabled;
    rgSynthesizerAddress.Enabled := Enabled;
    rgPolarity.Enabled           := Enabled;
    rgTunerReset.Enabled         := Enabled;
    rgLnbPower.Enabled           := Enabled;
  end;
begin
  case rgCard.ItemIndex of
    0, 2,
    8   : begin
            SetOptions(False);
            rgTuner.ItemIndex              := 0;
            rgSynthesizerAddress.ItemIndex := 1;
            rgPolarity.ItemIndex           := 0;
            rgTunerReset.ItemIndex         := 2;
            rgLnbPower.ItemIndex           := 1;
          end;
    1, 3: begin
            SetOptions(False);
            rgTuner.ItemIndex              := 1;
            rgSynthesizerAddress.ItemIndex := 0;
            rgPolarity.ItemIndex           := 0;
            rgTunerReset.ItemIndex         := 2;
            rgLnbPower.ItemIndex           := 1;
          end;
    4, 5,
    6, 7: begin
            SetOptions(False);
            rgTuner.ItemIndex              := -1;
            rgSynthesizerAddress.ItemIndex := -1;
            rgPolarity.ItemIndex           := -1;
            rgTunerReset.ItemIndex         := -1;
            rgLnbPower.ItemIndex           := -1;
          end;
    9:    begin
            SetOptions(False);
            rgSynthesizerAddress.ItemIndex := 1;
          end;
    10:   begin
            SetOptions(False);
            rgTuner.ItemIndex              := 1;
            rgSynthesizerAddress.ItemIndex := 1;
            rgPolarity.ItemIndex           := 1;
            rgTunerReset.ItemIndex         := rgTunerReset.Items.Count - 1;
            rgLnbPower.ItemIndex           := rgLnbPower.Items.Count - 1;
          end;
    11:   begin
            SetOptions(True);
          end;
  end;
end;


procedure TfrmSetupCard.rgPolarityClick(Sender: TObject);
begin
  if not rgPolarity.Enabled then
    Exit;
  // Check on identical OPx lines
  if rgPolarity.ItemIndex <> (rgPolarity.Items.Count - 1) then
  begin
    if (rgPolarity.ItemIndex = rgLnbPower.ItemIndex) then
      rgPolarity.ItemIndex := rgPolarity.Items.Count - 1;
  end;
end;


procedure TfrmSetupCard.rgLnbPowerClick(Sender: TObject);
begin
  if not rgLnbPower.Enabled then
    Exit;
  // Check on identical OPx lines
  if rgLnbPower.ItemIndex <> (rgLnbPower.Items.Count - 1) then
  begin
    if (rgLnbPower.ItemIndex = rgPolarity.ItemIndex) then
      rgLnbPower.ItemIndex   := (rgLnbPower.Items.Count - 1);
  end;
end;


procedure TfrmSetupCard.btnRevertClick(Sender: TObject);
begin
  Revert;
end;


procedure TfrmSetupCard.btnOKClick(Sender: TObject);
begin
  FAccepted := True;
  Hide;
  Refresh;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupCard.btnDiscardClick(Sender: TObject);
begin
  Hide;
  Refresh;
  Revert;
  if Assigned(@FExitCallback) then
    FExitCallback(nil);
  // Never call it again
  @FExitCallback := nil;
  Close;
end;


procedure TfrmSetupCard.FormCreate(Sender: TObject);
begin
  FOrgCardNumber         := 0;
  FOrgCard               := -1;
  FOrgTuner              := -1;
  FOrgSynthesizerAddress := -1;
  FOrgPolarity           := -1;
  FOrgTunerReset         := -1;
  FOrgLnbPower           := -1;
  FOrgThreadPriority     := 0;
  FOrgRpsProgram         := 0;
  FOrgBufferSize         := 0;
  FOrgMasterMode         := -1;
  @FExitCallback         := nil;
  FAccepted              := False;
  cmbCardNumber.ItemIndex     := FOrgCardNumber;
  cmbThreadPriority.ItemIndex := FOrgThreadPriority;
  cmbRpsProgram.ItemIndex     := FOrgRpsProgram;
  cmbBufferSize.ItemIndex     := FOrgBufferSize;
end;


procedure TfrmSetupCard.FormDestroy(Sender: TObject);
begin
  btnDiscardClick(nil);
  @FExitCallback := nil;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
  //
end;


initialization
  Initialize;


finalization
  Finalize;

end.

