{******************************************************************************}
{ FileName............: UInstallDriver                                         }
{ Project.............: -                                                      }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.01                                                   }
{------------------------------------------------------------------------------}
{  Install (force) an update of the driver.                                    }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040704 - Initial release                                           }
{  1.01   20040705 - Auto complete of installation even with 'non digitally    }
{                    signed' driver                                            }
{******************************************************************************}
unit UInstallDriver;

interface

uses
  IniFiles,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TfrmInstallDriver = class(TForm)
    btnExit: TButton;
    btnInstallDriver: TButton;
    edtPciDevice: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    edtInfFile: TEdit;
    dlgOpen: TOpenDialog;
    btnBrowse: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure btnInstallDriverClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnBrowseClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

function UpdateDriverForPlugAndPlayDevicesA(hwndParent: HWND;
  HardwareId: LPCSTR; FullInfPath: LPCSTR; InstallFlags: DWORD;
  bRebootRequired: PBOOL): BOOL; stdcall;
function UpdateDriverForPlugAndPlayDevicesW(hwndParent: HWND;
  HardwareId: LPCWSTR; FullInfPath: LPCWSTR; InstallFlags: DWORD;
  bRebootRequired: PBOOL): BOOL; stdcall;
function UpdateDriverForPlugAndPlayDevices(hwndParent: HWND;
  HardwareId: LPCSTR; FullInfPath: LPCSTR; InstallFlags: DWORD;
  bRebootRequired: PBOOL): BOOL; stdcall;


var
  frmInstallDriver: TfrmInstallDriver;

implementation

{$R *.DFM}
const
  INSTALLFLAG_FORCE = $00000001;                 // Force the installation of the specified driver
  newdev            = 'newdev.dll';

function UpdateDriverForPlugAndPlayDevicesA; external newdev name 'UpdateDriverForPlugAndPlayDevicesA';
function UpdateDriverForPlugAndPlayDevicesW; external newdev name 'UpdateDriverForPlugAndPlayDevicesW';
function UpdateDriverForPlugAndPlayDevices;  external newdev name 'UpdateDriverForPlugAndPlayDevicesA';

type
  TCheckThread = class(TThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  end;

var
  Silent           : Boolean;
  Loop             : Integer;
  IniFile          : TIniFile;
  Error            : Dword;
  IniName          : string;
  ExeDirectory     : string;
  InfFile          : string;
  PciDevice        : string;
  CaptionText      : string;
  KeyboardCharacter: string;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Thread checking for confirmation 'dialog'
  Notes   :
 ------------------------------------------------------------------------------}
procedure TCheckThread.Execute;
var
  Target: THandle;
  Cap   : array[0..127] of Char;
  Key   : Byte;
begin
  StrPCopy(Cap, CaptionText);
  if Length(KeyboardCharacter) > 0 then
    Key := Ord(KeyboardCharacter[1])
  else
    Key := 0;
  repeat
    Target := FindWindow(nil, Cap);
    if Target <> 0 then
      KeyBd_Event(Key, MapVirtualKey(Key, 0), 0, 0)
    else
      Sleep(10);  
  until Terminated or (Target <> 0);
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Install driver
  Notes   :
 ------------------------------------------------------------------------------}
function InstallDriver: string;
var
  InfFileName  : PChar;
  PciDeviceName: PChar;
  ErrorMessage : string;
  ExitThread   : TCheckThread;
begin
  Result := '';
  ExitThread := TCheckThread.Create(False);
  GetMem(InfFileName, 128);
  GetMem(PciDeviceName, 128);
  try
    StrPCopy(InfFileName,   InfFile);
    StrPCopy(PciDeviceName, PciDevice);
    if UpdateDriverForPlugAndPlayDevices(Application.Handle, PciDeviceName,
         InfFileName, INSTALLFLAG_FORCE, nil) then
      Exit;
    Error := GetLastError();
    ErrorMessage := SysErrorMessage(Error);
    if Error = ERROR_FILE_NOT_FOUND then
      Result := '  Error installing driver:  The  [Installation file]  is incorrect (check path).';
    // Next error should never happen because of fixed flags ...
    if Error = ERROR_INVALID_FLAGS then ;
    if Error = $E000022F then                //  ERROR_NO_CATALOG_FOR_OEM_INF
      Result := '  Error installing driver:  Installation stopped (no catalog?).';
    if Error = $E0000235 then                // ERROR_IN_WOW64
      Result := '  Error installing driver:  32-bit application attempting to execute in 64-bit.';
    if Error = $E000020B then                // ERROR_NO_SUCH_DEVINST
      Result := '  Error installing driver:  The  [PCI device]  does not match any plugged in devices.';
    // Next error never happens because of force flag ....
    if Error = NO_ERROR then ;
    if Result = '' then
      Result := format('  Error installing driver [$%8.8x]: %s', [Error, ErrorMessage]);
   finally
     FreeMem(InfFileName, 128);
     FreeMem(PciDeviceName, 128);
     ExitThread.Terminate;
     ExitThread.WaitFor;
     ExitThread.Free;
   end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Exit button
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmInstallDriver.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Install the driver
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmInstallDriver.btnInstallDriverClick(Sender: TObject);
begin
  btnInstallDriver.Enabled := False;
  btnExit.Enabled := False;
  Caption := '  Installing driver ...';
  Refresh;
  try
    InfFile   := edtInfFile.Text;
    PciDevice := edtPciDevice.Text;
    Caption   := InstallDriver;
    if Caption = '' then
      Caption := '  Installation driver successful.'
   finally
     btnInstallDriver.Enabled := True;
     btnExit.Enabled := True;
   end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Form creation
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmInstallDriver.FormCreate(Sender: TObject);
begin
  edtInfFile.Text   := InfFile;
  edtPciDevice.Text := PciDevice;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Open dialog
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmInstallDriver.btnBrowseClick(Sender: TObject);
begin
  if dlgOpen.Execute then
    edtInfFile.Text := dlgOpen.FileName;
end;


initialization
  ExeDirectory := ExtractFilePath(Application.ExeName);
  IniName := ExeDirectory + 'InstallDriver.ini';
  Silent  := False;
  if ParamCount <> 0 then
  begin
    for Loop := 1 to ParamCount do
    begin
      if LowerCase(ParamStr(Loop)) = 'noform' then
        Silent := True
      else
      begin
        IniName := ParamStr(Loop);
        if Pos('\', IniName) = 0 then
          IniName := ExeDirectory + IniName;
      end;
    end;
  end;
  InfFile           := 'SAA7146A.INF';
  PciDevice         := 'PCI\VEN_1131&DEV_7146';
  CaptionText       := 'Hardware Installation';
  KeyboardCharacter := 'C';
  if FileExists(IniName) then
  begin
    IniFile := TIniFile.Create(IniName);
    try
      InfFile           := IniFile.ReadString('Generic', 'InfFile' , InfFile);
      PciDevice         := IniFile.ReadString('Generic', 'Device'  , PciDevice);
      CaptionText       := IniFile.ReadString('Generic', 'Caption' , CaptionText);
      KeyboardCharacter := IniFile.ReadString('Generic', 'Keyboard', KeyboardCharacter);
    finally
      IniFile.Free;
    end;
  end;
  if Silent then
  begin
    if InstallDriver <> '' then
      ExitCode := Error and $FF
    else
      ExitCode := 0;
//    Halt(ExitCode);
    Application.Terminate;
  end;



end.
