@echo off
@rem First clear the resulting file
@echo   Note: Errors in the original data will generate no result at all! >RESULT.RCX
@rem Note that the result is appended to the RESULT.RCX file when using '>>RESULT.RCX'

@rem Simplest form: frequency and such are default (36000 Hz, delay 69 ms, no toggle, with repeat, output is learned data)
@rem RC5 system command
@echo   Default settings are always: >>RESULT.RCX
@echo     Frequency = 36000 Hz >>RESULT.RCX
@echo     Delay     = 69 ms >>RESULT.RCX
@echo     Toggle    = off >>RESULT.RCX
@echo     Repeat    = on! >>RESULT.RCX
@echo     Output    = learned data (0000) >>RESULT.RCX
@echo - >>RESULT.RCX
@echo   RC5 default settings >>RESULT.RCX
GenerateRCx RC5 0 0 >>RESULT.RCX
@rem RC5X system command data
@echo - >>RESULT.RCX
@echo   RC5X default settings >>RESULT.RCX
GenerateRCx RC5X 0 0 0 >>RESULT.RCX
@rem RC6 system command
@echo - >>RESULT.RCX
@echo   RC6 default settings >>RESULT.RCX
GenerateRCx RC6 0 0 >>RESULT.RCX
@rem RC6A customer system command
@echo - >>RESULT.RCX
@echo   RC6A default settings >>RESULT.RCX
GenerateRCx RC6A 0 0 0 >>RESULT.RCX

@rem The same as above but with the original data included in the result file. Add '10' to the required output format
@rem Since the default format is 0, we use 10 here
@rem RC5 system command
@echo - >>RESULT.RCX
@echo   RC5 with source data output >>RESULT.RCX
GenerateRCx RC5 0 0 10 >>RESULT.RCX
@echo - >>RESULT.RCX
@rem RC5X system command data
@echo   RC5X with source data output >>RESULT.RCX
GenerateRCx RC5X 0 0 0 10 >>RESULT.RCX
@echo - >>RESULT.RCX
@rem RC6 system command
@echo   RC6 with source data output >>RESULT.RCX
GenerateRCx RC6 0 0 10 >>RESULT.RCX
@echo - >>RESULT.RCX
@rem RC6A customer system command
@echo   RC6A with source data output >>RESULT.RCX
GenerateRCx RC6A 0 0 0 10 >>RESULT.RCX

@rem RC5 possible input formats
@rem ==========================
@rem RC5 system command format                                      Short form (note: 'format' is always optional)
@rem RC5 frequency delay toggle repeat system command format        Full form
@rem 5000 0000 0000 0001 system command format                      Short form 2
@rem 5000 ffff 0000 0001 system command format                      Short form 2 with specific frequency 'ffff' in carrier units!
@echo - >>RESULT.RCX
@echo   RC5 possible input formats >>RESULT.RCX
@echo   ========================== >>RESULT.RCX
GenerateRCx RC5 0 10 10 >>RESULT.RCX
GenerateRCx RC5 36000 69 0 0 0 10 10 >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 0000 000A 10 >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 0012 0073 10 >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 000F 0023 10 >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 0003 004A 10 >>RESULT.RCX
GenerateRCx 5000 006B 0000 0001 0000 000A 10 >>RESULT.RCX

@rem RC5X possible input formats
@rem ===========================
@rem RC5X system command data format                                Short form
@rem RC5X frequency delay toggle repeat system command data format  Full form
@rem 5001 0000 0000 0002 system command data 0000 format            Short form 2
@rem 5001 ffff 0000 0002 system command data 0000 format            Short form 2 with specific frequency 'ffff' in carrier units!
@echo - >>RESULT.RCX
@echo   RC5X possible input formats >>RESULT.RCX
@echo   =========================== >>RESULT.RCX
GenerateRCx RC5X 0 10 20 10 >>RESULT.RCX
GenerateRCx RC5X 36000 69 0 0 0 10 20 10 >>RESULT.RCX
GenerateRCx 5001 0000 0000 0002 0000 000A 0014 0000 10 >>RESULT.RCX
GenerateRCx 5001 0000 0000 0002 0012 0073 0012 0000 10 >>RESULT.RCX
GenerateRCx 5001 0000 0000 0002 000F 0023 0023 0000 10 >>RESULT.RCX
GenerateRCx 5001 0000 0000 0002 0003 004A 0011 0000 10 >>RESULT.RCX
GenerateRCx 5001 006B 0000 0002 0000 000A 0014 0000 10 >>RESULT.RCX

@rem RC6 possible input formats
@rem ==========================
@rem RC6 system command format                                      Short form
@rem RC6 frequency delay toggle repeat system command format        Full form
@rem 6000 0000 0000 0001 system command format                      Short form 2
@rem 6000 ffff 0000 0001 system command format                      Short form 2 with specific frequency 'ffff' in carrier units!
@echo - >>RESULT.RCX
@echo   RC6 possible input formats >>RESULT.RCX
@echo   ========================== >>RESULT.RCX
GenerateRCx RC6 0 10 10 >>RESULT.RCX
GenerateRCx RC6 36000 69 0 0 0 10 10 >>RESULT.RCX
GenerateRCx 6000 0000 0000 0001 0000 000A 10 >>RESULT.RCX
GenerateRCx 6000 0000 0000 0001 0012 0073 10 >>RESULT.RCX
GenerateRCx 6000 0000 0000 0001 000F 0023 10 >>RESULT.RCX
GenerateRCx 6000 0000 0000 0001 0003 004A 10 >>RESULT.RCX
GenerateRCx 6000 006B 0000 0001 0000 000A 10 >>RESULT.RCX

@rem RC6A possible input formats
@rem ===========================
@rem RC6A customer system command format                                Short form
@rem RC6 frequency delay toggle repeat customer system command format   Full form
@rem 6001 0000 0000 0002 customer system command 0000 format            Short form 2
@rem 6001 ffff 0000 0002 customer system command 0000 format            Short form 2 with specific frequency 'ffff' in carrier units!
@echo - >>RESULT.RCX
@echo   RC6A possible input formats >>RESULT.RCX
@echo   =========================== >>RESULT.RCX
GenerateRCx RC6A 20 0 10 10 >>RESULT.RCX
GenerateRCx RC6A 36000 69 0 0 10 0 10 10 >>RESULT.RCX
GenerateRCx 6001 0000 0000 0002 0014 0000 000A 0000 10 >>RESULT.RCX
GenerateRCx 6001 0000 0000 0002 0012 0073 0012 0000 10 >>RESULT.RCX
GenerateRCx 6001 0000 0000 0002 000F 0023 0023 0000 10 >>RESULT.RCX
GenerateRCx 6001 0000 0000 0002 0003 004A 0011 0000 10 >>RESULT.RCX
GenerateRCx 6001 006B 0000 0002 0014 0000 000A 0000 10 >>RESULT.RCX

@rem Possible output formats
@rem =======================
@echo - >>RESULT.RCX
@echo   Possible output formats >>RESULT.RCX
@echo   ======================= >>RESULT.RCX
@echo   Learned code format >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 0000 000A 0 >>RESULT.RCX
@echo   Short form 1 >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 0000 000A 1 >>RESULT.RCX
@echo   Short form 2 >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 0000 000A 2 >>RESULT.RCX
@echo   Bitstream (not encoded) >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 0000 000A 3 >>RESULT.RCX
@echo   Encoded bitstream (half bits) >>RESULT.RCX
GenerateRCx 5000 0000 0000 0001 0000 000A 4 >>RESULT.RCX

@rem Checking RC6A with Pronto generated data
@rem ========================================
@echo - >>RESULT.RCX
@echo   Checking RC6A (ProntoEdit converts this into a learned format!) >>RESULT.RCX
@echo   ================================================================ >>RESULT.RCX
GenerateRCx RC6A 1 2 3 >>RESULT.RCX
GenerateRCx RC6A 4 5 6 >>RESULT.RCX
GenerateRCx RC6A 7 8 9 >>RESULT.RCX

GenerateRCx RC6A 0 0 0 >>RESULT.RCX
GenerateRCx RC6A 1 0 0 >>RESULT.RCX
GenerateRCx RC6A 0 1 0 >>RESULT.RCX
GenerateRCx RC6A 0 0 1 >>RESULT.RCX
GenerateRCx RC6A 41251 1 1 >>RESULT.RCX




