{****************************************************************************}
{ Program: ProntoRcX.inc                                                     }
{ Author : M.Majoor                                                          }
{----------------------------------------------------------------------------}
{ Common types                                                               }
{                                                                            }
{ Version                                                                    }
{  1.00   20020825  - First release                                          }
{****************************************************************************}

type
  // RC5/6 system types
  TRCSystemTypeRCx = (rstTelevision1, rstTelevision2, rstTeletext, rstTelevisionExtension, rstLaserVideo, rstVideoRecorder1, rstVideoRecorder2, rstReserved_Test,
                      rstSatellite1, rstVideoRecorderExtension, rstSatellite2, rstReserved_Measurement, rstCDVideo, rstReserved_Medical, rstCDPhoto, rstReserved_SidAV,
                      rstAmplifier1, rstTuner, rstCassette, rstAmplifier2, rstCDPlayer, rstAudioRecorder, rstSatelliteAudio, rstDigitalCompactCassette,
                      rstReserved_LC, rstReserved_UC, rstCDRecorder, rstReserved_HearingAid, rstReserved_NatLab, rstReserved_Light1, rstReserved_Light2, rstReserved_SS);

  // Indexes of the parameters. Note that different remote control protocols use
  // different names for the same function:
  //   rptAddress   :  Address / System / Product / Manufacturer
  //   rptCommand   :  Command / Instruction / Key pressed / Function
  //   rptData      :  Data / System
  //   rptCustomer  :  Customer / Manufacturer
  //   rptToggle    :  Toggle / Parity
  //   rptChecksum  :  Checksum
  // The order is from top to bottom. The first two parameters are almost always
  // used. Some names might appear twice but this is because protocols use them
  // differently or might have two almost identical parameters.
  // The following list gives a summary of the necessary parameters for
  // different protocols. Note that the <rptRepeat>/<rptDelay> can be used
  // for all protocols if necessary (the will then just indicate a repeated code).
  // Some protocols need to have a repeat implicitly.
  // RC5 :          rptAddress,           Address (system)
  //                rptCommand,           Command
  //                rptToggle             Toggle bit
  // RC5x:          rptAddress,           Address (system)
  //                rptCommand,           Command
  //                rptData,              Data
  //                rptToggle             Toggle bit
  // RC6 :          rptAddress,           Address (system)
  //                rptCommand,           Command
  //                rptToggle             Toggle bit
  // RC6A:          rptAddress,           Address (system)
  //                rptCommand,           Command
  //                rptCustomer,          Customer code
  //                rptToggle             Toggle bit
  // SIRCS/CNTRL-S: rptAddress,           Address
  // (SONY)         rptCommand,           Command
  //                rptData,              Extension
  //                rptRepeat             Number of repeats (>=2)
  // RECS80:        rptAddress,           Address (system)
  //                rptCommand,           Command
  //                rptToggle             Toggle bit
  // DENON:         rptAddress,           Address
  //                rptCommand            Command
  // NEC:           rptAddress,           Address
  //                rptCommand,           Command
  //                rptToggle             Indicates key is still being pressed
  // MOTOROLA:      rptCommand            Command
  // JAPAN:         rptAddress            System code
  //                rptCommand            Command
  //                rptData               Product code
  //                rptCustomer           Manufacturer
  //                rptToggle             Parity
  //                rptChecksum           Data check
  // DAEWOO:        rptAddress            Manufacturer
  //                rptCommand            Command
  TRCParameterType = (rptAddress, rptCommand, rptData, rptCustomer, rptToggle,
                      rptChecksum, rptRepeat, rptFrequency, rptDelay, rptReserved1);

  // A maximum of 10 parameters are used
  TRCParameters = array[low(TRCParameterType)..high(TRCParameterType)] of Dword;


