{******************************************************************************}
{ FileName............: FindingCarrierUnit001                                  }
{ Project.............: FLEXCOP                                                }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Finding a carrier.                                                          }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040525 - Initial WDM release                                       }
{******************************************************************************}
unit FindingCarrierUnit001;

interface

uses
  SyncObjs,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FlexCopInterface, FlexCopregisters, FlexCopGeneral, FlexCopI2c, Stv0299bRegisters,
  Sl1935Registers, ExtCtrls, Mask, Gauges;

type
  TfrmMain = class(TForm)
    btnExit: TButton;
    mmoDriver: TMemo;
    rgPolarity: TRadioGroup;
    mskSymbolRate: TMaskEdit;
    StaticText1: TStaticText;
    tmrUpdate: TTimer;
    ggLock: TGauge;
    StaticText2: TStaticText;
    StaticText3: TStaticText;
    mskFrequency: TMaskEdit;
    StaticText4: TStaticText;
    stDeviation: TStaticText;
    StaticText5: TStaticText;
    StaticText6: TStaticText;
    StaticText7: TStaticText;
    stDeviationSymbolrate: TStaticText;
    btnBeforeLock: TButton;
    btnAfterLock: TButton;
    rgLNB: TRadioGroup;
    btnReset: TButton;
    StaticText8: TStaticText;
    rgInversion: TRadioGroup;
    rgAGC: TRadioGroup;
    btnOptionASatA: TButton;
    btnOptionASatB: TButton;
    btnOptionBSatA: TButton;
    btnOptionBSatB: TButton;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure rgPolarityClick(Sender: TObject);
    procedure mskSymbolRateChange(Sender: TObject);
    procedure tmrUpdateTimer(Sender: TObject);
    procedure mskFrequencyChange(Sender: TObject);
    procedure mskFrequencyKeyPress(Sender: TObject; var Key: Char);
    procedure mskSymbolRateKeyPress(Sender: TObject; var Key: Char);
    procedure btnBeforeLockClick(Sender: TObject);
    procedure btnAfterLockClick(Sender: TObject);
    procedure rgLNBClick(Sender: TObject);
    procedure btnResetClick(Sender: TObject);
    procedure rgInversionClick(Sender: TObject);
    procedure rgAGCClick(Sender: TObject);
    procedure btnOptionSatClick(Sender: TObject);
  private
    { Private declarations }
    FCardHandle : THandle;
    FCardNoError: Boolean;
    FFrequencySearch: Boolean;
    FFrequencySearchCountDown: Byte;
    FSynthesizerAddress: Byte;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;


implementation

{$R *.DFM}

{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Creation of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);
begin
  FCardHandle  := INVALID_HANDLE_VALUE;
  FCardNoError := False;
  FFrequencySearch := False;
  FFrequencySearchCountDown := 0;
  // Check if the driver is present and/or multiple cards are present
  case FlexCopGetNumberOfCards of
    0:   mmoDriver.Lines.Add('No FLEXCOP driver and/or card detected.');
  end;
  // If any card detected then display additional information
  if FlexCopGetNumberOfCards <> 0 then
    FCardHandle := FlexCopCreateFile(-1);
  btnResetClick(nil);
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Destruction of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  if FCardHandle <> INVALID_HANDLE_VALUE then
  begin
    FlexCopDisableLNB(FCardHandle);
    FlexCopCloseHandle(FCardHandle);
  end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Exit application.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


procedure TfrmMain.rgPolarityClick(Sender: TObject);
begin
  case rgPolarity.ItemIndex of
    0: if not FlexCopHorizontalPolarityLNB(FCardHandle) then
         mmoDriver.Lines.Add('Could not set horizontal polarity.');
    1: if not FlexCopVerticalPolarityLNB(FCardHandle) then
         mmoDriver.Lines.Add('Could not set vertical polarity.');
  end;
end;


procedure TfrmMain.mskSymbolRateChange(Sender: TObject);
var
  SymbolRate: Dword;
  Error:      Integer;
begin
  Val(mskSymbolRate.EditText, SymbolRate, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Could not convert symbolrate.');
    Exit;
  end;
  if not FlexCopQpskSetSymbolRate(FCardHandle, SymbolRate) then
    mskSymbolRate.Color := clRed
  else
    mskSymbolrate.Color := clLime;
end;


procedure TfrmMain.tmrUpdateTimer(Sender: TObject);
var
  Percentage: Byte;
  Deviation : Integer;
  Frequency : Dword;
  Error     : Integer;
  PowerPercentage: Double;
  PowerDecibel   : Double;
  LockState : Byte;
  Noise     : Double;
  StatusStr : string;
begin
FFrequencySearch := False;
  if FlexCopQpskGetLockDetectorPercentage(FCardHandle, Percentage) then
    ggLock.Progress := Percentage;
  if FlexCopQpskGetCarrierDeviation(FCardHandle, Deviation) then
    stDeviation.Caption := format('%d', [Deviation]);
  if FlexCopQpskGetSymbolRateDeviation(FCardHandle, Deviation) then
    stDeviationSymbolRate.Caption := format('%d', [Deviation]);
  if FFrequencySearch then
  begin
    Val(mskFrequency.EditText, Frequency, Error);
    if Error = 0 then
    begin
      Frequency := Frequency + Deviation;
      mskFrequency.Text := format('%d', [Frequency]);
      mskFrequencyChange(nil);
    end;
    if FFrequencySearchCountDown <> 0 then
      Dec(FFrequencySearchCountDown);
    if FFrequencySearchCountDown = 0 then
      FFrequencySearch := False;
  end;

  if FlexCopQpskGetSignalPower(FCardHandle, PowerPercentage, PowerDecibel) then
  begin
    statictext5.caption := format('Power %f%% (%f dB)', [PowerPercentage, PowerDecibel]);
  end;
  if FlexCopReadFromQpsk(FCardHandle, CStv0299bVStatus, LockState) then
  begin
    if (LockState and $80) <> 0 then
      StatusStr := 'CARRIER'
    else
      StatusStr := 'NO CARRIER';
    if (LockState and $10) <> 0 then
      StatusStr := StatusStr + ' - VITERBI'
    else
      StatusStr := StatusStr + ' - NO VITERBI';
    if (LockState and $08) <> 0 then
      StatusStr := StatusStr + ' - SYNC'
    else
      StatusStr := StatusStr + ' - NO SYNC';
    if (LockState and $98) = $98 then
      StatusStr := StatusStr + ' - LOCK'
    else
      StatusStr := StatusStr + ' - NO LOCK';
    statictext6.caption := format('Status $%2.2x : %s', [LockState, StatusStr]);
  end;
  if FlexCopQpskGetNoiseIndicator(FCardHandle, Noise) then
  begin
    statictext8.caption := format('Noise %f dB', [Noise]);
  end;
end;

procedure TfrmMain.mskFrequencyChange(Sender: TObject);
var
  Frequency: Dword;
  Error:     Integer;
begin
  Val(mskFrequency.EditText, Frequency, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Could not convert frequency.');
    Exit;
  end;

  if not FlexCopFrequencyLNB(FCardHandle, Frequency, 9750000, 10600000, 0, FSynthesizerAddress) then
    mskFrequency.Color := clRed
  else
    mskFrequency.Color := clLime;
  if FFrequencySearchCountDown = 0 then
  begin
//    FlexCopWriteToQpsk(FCardHandle, CStv0299bBclc, LockState) then
      FFrequencySearchCountDown := 10;
  end;
  FFrequencySearch := True;
end;

procedure TfrmMain.mskFrequencyKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    mskFrequencyChange(nil);
end;

procedure TfrmMain.mskSymbolRateKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    mskSymbolrateChange(nil);
end;

procedure TfrmMain.btnBeforeLockClick(Sender: TObject);
var
  Data: Byte;
begin
  if not FlexCopReadFromQpsk(FCardHandle, CStv0299bCfd, Data) then
    Exit;
  Data := Data or  $80;
  FlexCopWriteToQpsk(FCardHandle, CStv0299bCfd, Data);
end;

procedure TfrmMain.btnAfterLockClick(Sender: TObject);
var
  Data: Byte;
begin
  if not FlexCopReadFromQpsk(FCardHandle, CStv0299bCfd, Data) then
    Exit;
  Data := Data and $7F;
  FlexCopWriteToQpsk(FCardHandle, CStv0299bCfd, Data);
end;

procedure TfrmMain.rgLNBClick(Sender: TObject);
begin
  case rgLNB.ItemIndex of
    0: if not FlexCopEnableLNB(FCardHandle) then
         mmoDriver.Lines.Add('Could not enable LNB.');
    1: if not FlexCopDisableLNB(FCardHandle) then
         mmoDriver.Lines.Add('Could not disable LNB.');
  end;
end;

procedure TfrmMain.btnResetClick(Sender: TObject);
var
  ReturnedByte : Byte;
  Address      : Integer;
  Success      : Boolean;
begin
  FCardNoError := False;
  FSynthesizerAddress := FlexCopDetectSynthesizerAddress(FCardHandle);

  // Pseudo reset
  FlexCopWriteToFlexCopRegister(FCardhandle, CFlexCopSpecials, CFlexCopSpecialReset);
  Sleep(1);
  FlexCopWriteToFlexCopRegister(FCardhandle, CFlexCopPowerAndRevision, 0);
  Sleep(1);
  FlexCopWriteToFlexCopRegister(FCardhandle, CFlexCopPowerAndRevision, CFlexCopBoardReset);
  Sleep(1);

  FlexCopWriteToFlexCopRegister(FCardhandle, CFlexCopPowerAndRevision, CFlexCopTunerPowerOn or CFlexCopLNBPolarityHorizontal or CFlexCopSystemPowerOn or CFlexCopWakeUpOn);

  if not FlexCopReadFromQpsk(FCardHandle, CStv0299bId, ReturnedByte) then
  begin
    mmoDriver.Lines.Add('Could not read identification of QPSK demodulator.');
    Exit;
  end;
  if not ReturnedByte = $A1 then
  begin
    mmoDriver.Lines.Add(format('QPSK demodulator identification NOT correct ($%x).', [ReturnedByte]));
    Exit;
  end
  else
    mmoDriver.Lines.Add(format('QPSK demodulator identification correct ($%x).', [ReturnedByte]));

  if not FlexCopWriteDefaultsToQpsk(FCardHandle, 0) then
  begin
    mmoDriver.Lines.Add('QPSK registers could not be set to default values.');
    Exit;
  end
  else
    mmoDriver.Lines.Add('QPSK registers set to default values.');
  FCardNoError := True;
  rgPolarityClick(nil);
  rgLNBClick(nil);
  rgInversionClick(nil);
  //
  mskFrequencyChange(nil);
  mskSymbolrateChange(nil);
  if FCardNoError then
    tmrUpdate.Enabled := True;
end;

procedure TfrmMain.rgInversionClick(Sender: TObject);
begin
  case rgInversion.ItemIndex of
    0: if not FlexCopQpskSetInversion(FCardHandle, True) then
         mmoDriver.Lines.Add('Could not set inversion.');
    1: if not FlexCopQpskSetInversion(FCardHandle, False) then
         mmoDriver.Lines.Add('Could not reset inversion.');
  end;
end;



procedure TfrmMain.rgAGCClick(Sender: TObject);
begin
  case rgAGC.ItemIndex of
    0: if not FlexCopQpskSetAGCInversion(FCardHandle, True) then
         mmoDriver.Lines.Add('Could not set AGC inversion.');
    1: if not FlexCopQpskSetAGCInversion(FCardHandle, False) then
         mmoDriver.Lines.Add('Could not reset AGC inversion.');
  end;
end;


procedure TfrmMain.btnOptionSatClick(Sender: TObject);
var
  DiSEqcData: TDiSEqCData;
  BName     : string;
begin
  DiSEqCData[3] := $F0;
  if not (Sender is TButton) then
    Exit;
  with Sender as TButton do
    BName := Name;
  if BName = 'btnOptionASatA' then
    DiSEqCData[3] := $F0;
  if BName = 'btnOptionASatB' then
    DiSEqCData[3] := $F4;
  if BName = 'btnOptionBSatA' then
    DiSEqCData[3] := $F8;
  if BName = 'btnOptionBSatB' then
    DiSEqCData[3] := $FC;
  DiSEqCData[0] := 0;                                      // Will be written over
  DiSEqCData[1] := $10;                                    // Any LNB/switcher
  DiSEqCData[2] := $38;                                    // Committed sitches (DiSEqc level 1.0)
  if not FlexCopDiSEqCCommand(FCardHandle, 2{DiSEqCRepeats}, CDiSEqCCommand, 4, DiSEqCData) then
    mmoDriver.Lines.Add('DiSEqC command Error')
  else
    mmoDriver.Lines.Add('DiSEqC command success');
end;


end.
