{******************************************************************************}
{ FileName............: CheckingTheDriverUnit001                               }
{ Project.............: FLEXCOP                                                }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Checking the driver.                                                        }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040515 - Initial WDM release                                       }
{******************************************************************************}
unit CheckingTheDriverUnit001;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FlexCopInterface, ExtCtrls;

type
  TfrmMain = class(TForm)
    btnExit: TButton;
    mmoDriver: TMemo;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Creation of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);
var
  CardHandle   : THandle;
  MajorVersion : Word;
  MinorVersion : Word;
  Build        : Dword;
  DeviceName   : string;
begin
  // Check if the driver is present and/or multiple cards are present
  case FlexCopGetNumberOfCards of
    0:   mmoDriver.Lines.Add('No FlexCop driver and/or card detected.');
    1:   mmoDriver.Lines.Add('One FlexCop card detected.');
    else mmoDriver.Lines.Add(format('%d FlexCop cards detected.', [FlexCopGetNumberOfCards]));
  end;
  // If any card detected then display additional information
  if FlexCopGetNumberOfCards <> 0 then
  begin
    // At this time we don't have a link to the driver itself. We have to create this.
    // We use the first available card (-1==auto) there is.
    CardHandle := FlexCopCreateFile(-1);
    try
      // Now with the handle we can actually access the driver.
      // Start with getting the version information of the driver.
      if FlexCopGetDriverVersion(CardHandle, MajorVersion, MinorVersion, Build, DeviceName) then
      begin
        mmoDriver.Lines.Add(format('Driver "%s", Version %d.%2.2d, Build %8.8x.', [DeviceName, MajorVersion, MinorVersion, Build]));
      end;
    finally
      FlexCopCloseHandle(CardHandle);
    end;
  end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Destruction of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  //
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Exit application.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


end.
