{******************************************************************************}
{ FileName............: Stv0299bRegisters                                      }
{ Project.............: SAA7146A                                               }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Register/constant definitions for the STV0299B (part of the tuner)          }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040522 - Initial release                                           }
{******************************************************************************}
unit Stv0299bRegisters;

interface

const
  // STV0299B QPSK demodulator is part of the tuner and connected to the I2C of
  // the SAA7146A or FLEXCOP
  // Note: the STV0299B needs a reset before I2C access is possible
  // It supports the 400 kHz (fast mode) protocol
  CStv0299bDemodulatorWriteAddress : Byte = $D0;
  CStv0299bDemodulatorReadAddress  : Byte = $D1;

{------------------------------------------------------------------------------
  Descript:  QPSK demodulator STV0299B registers
 -----------------------------------------------------------------------------}
  CStv0299bId           = $00;                             // $A1  <- typical values read after reset
  CStv0299bRcr          = $01;                             // $18
  CStv0299bMcr          = $02;                             // $34
  CStv0299bAcr          = $03;                             // $2A
  CStv0299bF22Fr        = $04;                             // $8E
  CStv0299bI2cRpt       = $05;                             // $0F
  CStv0299bDacR1        = $06;                             // $A2
  CStv0299bDacR2        = $07;                             // $00
  CStv0299bDiSEqC       = $08;                             // $60
  CStv0299bDiSEqCFifo   = $09;                             // $00
  CStv0299bDiSEqCStatus = $0A;                             // $52
  CStv0299bReserved1    = $0B;                             // $00
  CStv0299bIoCfg        = $0C;                             // $F0
  CStv0299bAgc1C        = $0D;                             // $81
  CStv0299bRtc          = $0E;                             // $23
  CStv0299bAgc1R        = $0F;                             // $54
  CStv0299bAgc2O        = $10;                             // $74
  CStv0299bTlsr         = $11;                             // $88
  CStv0299bCfd          = $12;                             // $F7
  CStv0299bAclc         = $13;                             // $88
  CStv0299bBclc         = $14;                             // $5C
  CStv0299bCldt         = $15;                             // $14
  CStv0299bAgc1I        = $16;                             // $80
  CStv0299bTl1R         = $17;                             // $03
  CStv0299bAgc2I1       = $18;                             // $FF
  CStv0299bAgc2I2       = $19;                             // $FF
  CStv0299bRtf          = $1A;                             // $01
  CStv0299bVStatus      = $1B;                             // $03
  CStv0299bCldi         = $1C;                             // $EC
  CStv0299bECntH        = $1D;                             // $89
  CStv0299bECntL        = $1E;                             // $BA
  CStv0299bSfrH         = $1F;                             // $80
  CStv0299bSfrM         = $20;                             // $00
  CStv0299bSfrL         = $21;                             // $00
  CStv0299bCfrM         = $22;                             // $FF
  CStv0299bCfrL         = $23;                             // $FF
  CStv0299bNirH         = $24;                             // $46
  CStv0299bNirL         = $25;                             // $81
  CStv0299bVError       = $26;                             // $45
  CStv0299bReserved2    = $27;                             // $00
  CStv0299bFecM         = $28;                             // $01
  CStv0299bVth0         = $29;                             // $1E
  CStv0299bVth1         = $2A;                             // $14
  CStv0299bVth2         = $2B;                             // $0F
  CStv0299bVth3         = $2C;                             // $09
  CStv0299bVth4         = $2D;                             // $05
  CStv0299bReserved3    = $2E;                             // $18
  CStv0299bReserved4    = $2F;                             // $0B
  CStv0299bReserved5    = $30;                             // $21
  CStv0299bPr           = $31;                             // $1F
  CStv0299bVSearch      = $32;                             // $19
  CStv0299bRs           = $33;                             // $F8
  CStv0299bErrCnt       = $34;                             // $01

{------------------------------------------------------------------------------
  Descript:  QPSK demodulator STV0299B registers explanatory descriptions
 -----------------------------------------------------------------------------}
  CStv0299bRegisterTexts : array[CStv0299bId..CStv0299bErrCnt] of string =
    ({CStv0299bId}           'Identification register',
     {CStv0299bRcr}          'Reference clock register',
     {CStv0299bMcr}          'Master clock register',
     {CStv0299bAcr}          'Auxiliary clock register',
     {CStv0299bF22Fr}        'F22 frequency register',
     {CStv0299bI2cRpt}       'I2C repeater register',
     {CStv0299bDacR1}        'DAC register 1',
     {CStv0299bDacR2}        'DAC register 2',
     {CStv0299bDiSEqC}       'DiSEqC and lock control register',
     {CStv0299bDiSEqCFifo}   'DiSEqC FIFO',
     {CStv0299bDiSEqCStatus} 'DiSEqC status',
     {CStv0299bReserved1}    'Reserved register 1',
     {CStv0299bIoCfg}        'Input/output configuration register',
     {CStv0299bAgc1C}        'AGC 1 control register',
     {CStv0299bRtc}          'Timing loop register',
     {CStv0299bAgc1R}        'AGC 1 reference register',
     {CStv0299bAgc2O}        'AGC 2 and offset control register',
     {CStv0299bTlsr}         'Timing lock setting register',
     {CStv0299bCfd}          'Carrier frequency detector register',
     {CStv0299bAclc}         'Alpha carrier and noise estimator register',
     {CStv0299bBclc}         'Beta carrier register',
     {CStv0299bCldt}         'Carrier lock detector threshold register',
     {CStv0299bAgc1I}        'AGC 1 integrator register',
     {CStv0299bTl1R}         'Timing lock indicator register',
     {CStv0299bAgc2I1}       'AGC 2 integrator register MSB',
     {CStv0299bAgc2I2}       'AGC 2 integrator register LSB',
     {CStv0299bRtf}          'Timing frequency register',
     {CStv0299bVStatus}      'VSTATUS register',
     {CStv0299bCldi}         'Carrier lock detector value register',
     {CStv0299bECntH}        'Error count register MSB',
     {CStv0299bECntL}        'Error count register LSB',
     {CStv0299bSfrH}         'Symbol frequency register HSB',
     {CStv0299bSfrM}         'Symbol frequency register MSB',
     {CStv0299bSfrL}         'Symbol frequency register LSB',
     {CStv0299bCfrM}         'Carrier frequency register MSB',
     {CStv0299bCfrL}         'Carrier frequency register LSB',
     {CStv0299bNirH}         'Noise indicator register MSB',
     {CStv0299bNirL}         'Noise indicator register LSB',
     {CStv0299bVError}       'VERROR register',
     {CStv0299bReserved2}    'Reserved register 2',
     {CStv0299bFecM}         'FEC mode register',
     {CStv0299bVth0}         'Viterbi threshold register rate 1/2',
     {CStv0299bVth1}         'Viterbi threshold register rate 2/3',
     {CStv0299bVth2}         'Viterbi threshold register rate 3/4',
     {CStv0299bVth3}         'Viterbi threshold register rate 5/6',
     {CStv0299bVth4}         'Viterbi threshold register rate 7/8 or 6/7',
     {CStv0299bReserved3}    'Reserved register 3',
     {CStv0299bReserved4}    'Reserved register 4',
     {CStv0299bReserved5}    'Reserved register 5',
     {CStv0299bPr}           'Puncture rate and synchronization register',
     {CStv0299bVSearch}      'Viterbi and synchronization search register',
     {CStv0299bRs}           'Reed-Solomon control register',
     {CStv0299bErrCnt}       'Error control register');


{------------------------------------------------------------------------------
  Descript:  Crystal related constants
 -----------------------------------------------------------------------------}
  CStv0299bCrystalFrequency      = 4000000;                // 4 MHz
  CStv0299bVcoMFactor            = 21;
  CStv0299bVcoKFactor            = 0;
  CStv0299bVcoPFactor            = 0;
  CStv0299bVcoPDivider           = 4;                      // 4, 6, 8, 12, 16, 24, 32, 48
  CStv0299bVco                   =
    CStv0299bCrystalFrequency * 4 * ((CStv0299bVcoMFactor + 1) div
                                     (CStv0299bVcoKFactor + 1));
  CStv0299bMasterClock           =
    CStv0299bVco div CStv0299bVcoPDivider;
  CStv0299bSetSymbolrateUnits: extended = CStv0299bMasterClock / 1048576;  // 2^20: 20 bits for 0-CStv0299bMasterClock Hz
  CStv0299bGetSymbolrateUnits: extended = CStv0299bMasterClock / 524288;   // 2^19: 19 bits is the timing frequency unit

{------------------------------------------------------------------------------
  Descript:  Default settings
 -----------------------------------------------------------------------------}
  CStv0299bDefaultsBSRU6 : array[CStv0299bId..CStv0299bErrCnt, 0..1] of byte =
    (($FF,                 0),                             // Not used for setting
     (CStv0299bRcr,        (CStv0299bVcoKFactor shl 6) or
                            CStv0299bVcoMFactor),          // Reference clock
     (CStv0299bMcr,        $30 or CStv0299bVcoPFactor),
     (CStv0299bAcr,        $00),
     (CStv0299bF22Fr,      CStv0299bVco div (22000 * 128)),
     (CStv0299bI2cRpt,     $35),                           // $05 $3x = repeater delay
     (CStv0299bDacR1,      $40),
     (CStv0299bDacR2,      $00),
     (CStv0299bDiSEqC,     $40),
     (CStv0299bDiSEqCFifo, $00),
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     (CStv0299bIoCfg,      $51),
     (CStv0299bAgc1C,      $82),
     (CStv0299bRtc,        $23),
     (CStv0299bAgc1R,      $12),
     (CStv0299bAgc2O,      $3F),
     (CStv0299bTlsr,       $84),
     (CStv0299bCfd,        $B5),
     (CStv0299bAclc,       $B6),
     (CStv0299bBclc,       $93),
     (CStv0299bCldt,       $C9),
     (CStv0299bAgc1I,      $1D),
     (CStv0299bTl1R,       $00),
     (CStv0299bAgc2I1,     $14),
     (CStv0299bAgc2I2,     $F2),
     (CStv0299bRtf,        $11),
     (CStv0299bVStatus,    $9C),                           // Read only ....
     (CStv0299bCldi,       $00),
     (CStv0299bECntH,      $00),
     (CStv0299bECntL,      $0B),
     (CStv0299bSfrH,       $50),
     (CStv0299bSfrM,       $00),
     (CStv0299bSfrL,       $00),
     (CStv0299bCfrM,       $00),
     (CStv0299bCfrL,       $00),
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     (CStv0299bFecM,       $00),
     (CStv0299bVth0,       $1E),
     (CStv0299bVth1,       $14),
     (CStv0299bVth2,       $0F),
     (CStv0299bVth3,       $09),
     (CStv0299bVth4,       $05),
     (CStv0299bReserved3,  $01),                           // ?? Reserved
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     (CStv0299bPr,         $1F),
     (CStv0299bVSearch,    $19),
     (CStv0299bRs,         $FC),
     (CStv0299bErrCnt,     $93));

{------------------------------------------------------------------------------
  Descript:  Default settings
 -----------------------------------------------------------------------------}
  CStv0299bDefaultsSU1278 : array[CStv0299bId..CStv0299bErrCnt, 0..1] of byte =
    (($FF,                 0),                             // Not used for setting
     (CStv0299bRcr,        (CStv0299bVcoKFactor shl 6) or
                            CStv0299bVcoMFactor),          // Reference clock
     (CStv0299bMcr,        $30 or CStv0299bVcoPFactor),
     (CStv0299bAcr,        $00),
     (CStv0299bF22Fr,      CStv0299bVco div (22000 * 128)),
     (CStv0299bI2cRpt,     $35),                           // $05 $3x = repeater delay
     (CStv0299bDacR1,      $40),
     (CStv0299bDacR2,      $00),
     (CStv0299bDiSEqC,     $40),
     (CStv0299bDiSEqCFifo, $00),
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     (CStv0299bIoCfg,      $50),                           // !!
     (CStv0299bAgc1C,      $82),
     (CStv0299bRtc,        $23),
     (CStv0299bAgc1R,      $92),                           // !!
     (CStv0299bAgc2O,      $3F),
     (CStv0299bTlsr,       $84),
     (CStv0299bCfd,        $B5),
     (CStv0299bAclc,       $B6),
     (CStv0299bBclc,       $93),
     (CStv0299bCldt,       $C9),
     (CStv0299bAgc1I,      $1D),
     (CStv0299bTl1R,       $00),
     (CStv0299bAgc2I1,     $14),
     (CStv0299bAgc2I2,     $F2),
     (CStv0299bRtf,        $11),
     (CStv0299bVStatus,    $9C),                           // Read only ....
     (CStv0299bCldi,       $00),
     (CStv0299bECntH,      $00),
     (CStv0299bECntL,      $0B),
     (CStv0299bSfrH,       $50),
     (CStv0299bSfrM,       $00),
     (CStv0299bSfrL,       $00),
     (CStv0299bCfrM,       $00),
     (CStv0299bCfrL,       $00),
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     (CStv0299bFecM,       $00),
     (CStv0299bVth0,       $1E),
     (CStv0299bVth1,       $14),
     (CStv0299bVth2,       $0F),
     (CStv0299bVth3,       $09),
     (CStv0299bVth4,       $05),
     (CStv0299bReserved3,  $01),                           // ?? Reserved
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     (CStv0299bPr,         $1F),
     (CStv0299bVSearch,    $19),
     (CStv0299bRs,         $FC),
     (CStv0299bErrCnt,     $93));

{------------------------------------------------------------------------------
  Descript:  Default settings
 -----------------------------------------------------------------------------}
  CStv0299bDefaultsTBMU24112 : array[CStv0299bId..CStv0299bErrCnt, 0..1] of byte =
    (($FF,                 0),                             // Not used for setting
     (CStv0299bRcr,        (CStv0299bVcoKFactor shl 6) or
                            CStv0299bVcoMFactor),          // Reference clock
     (CStv0299bMcr,        $30 or CStv0299bVcoPFactor),
     (CStv0299bAcr,        $00),
     (CStv0299bF22Fr,      CStv0299bVco div (22000 * 128)),
     (CStv0299bI2cRpt,     $35),                           // $05 $3x = repeater delay
     (CStv0299bDacR1,      $02),
     (CStv0299bDacR2,      $00),
     (CStv0299bDiSEqC,     $C3),
     (CStv0299bDiSEqCFifo, $00),
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     (CStv0299bIoCfg,      $00),
     (CStv0299bAgc1C,      $81),
     (CStv0299bRtc,        $23),
     (CStv0299bAgc1R,      $12),

     (CStv0299bAgc2O,      $7E),
     (CStv0299bTlsr,       $84),
     (CStv0299bCfd,        $B9),
     (CStv0299bAclc,       $88),
     (CStv0299bBclc,       $89),
     (CStv0299bCldt,       $C9),
     (CStv0299bAgc1I,      $00),
     (CStv0299bTl1R,       $5C),
     (CStv0299bAgc2I1,     $00),
     (CStv0299bAgc2I2,     $00),
     (CStv0299bRtf,        $00),
     (CStv0299bVStatus,    $9C),                           // Read only ....
     (CStv0299bCldi,       $00),
     (CStv0299bECntH,      $00),
     (CStv0299bECntL,      $00),
     (CStv0299bSfrH,       $3A),

     (CStv0299bSfrM,       $2E),
     (CStv0299bSfrL,       $80),
     (CStv0299bCfrM,       $FF),
     (CStv0299bCfrL,       $C1),
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     ($FF,                 0),                             // Not used for setting
     (CStv0299bFecM,       $00),
     (CStv0299bVth0,       $1E),
     (CStv0299bVth1,       $14),
     (CStv0299bVth2,       $0F),
     (CStv0299bVth3,       $09),
     (CStv0299bVth4,       $05),
     (CStv0299bReserved3,  $01),                           // ?? Reserved
     ($FF,                 0),                             // Not used for setting

     ($FF,                 0),                             // Not used for setting
     (CStv0299bPr,         $1F),
     (CStv0299bVSearch,    $19),
     (CStv0299bRs,         $FE),
     (CStv0299bErrCnt,     $93));

{------------------------------------------------------------------------------
  Descript:  Settings after a reset (for reference/check only)
 -----------------------------------------------------------------------------}
  CStv0299bResets : array[CStv0299bId..CStv0299bErrCnt, 0..1] of byte =
    ((CStv0299bId          , $A1),
     (CStv0299bRcr         , $18),
     (CStv0299bMcr         , $34),
     (CStv0299bAcr         , $2A),
     (CStv0299bF22Fr       , $8E),
     (CStv0299bI2cRpt      , $0F),
     (CStv0299bDacR1       , $A2),
     (CStv0299bDacR2       , $00),
     (CStv0299bDiSEqC      , $60),
     (CStv0299bDiSEqCFifo  , $00),
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     (CStv0299bIoCfg       , $F0),
     (CStv0299bAgc1C       , $81),
     (CStv0299bRtc         , $23),
     (CStv0299bAgc1R       , $54),
     (CStv0299bAgc2O       , $74),
     (CStv0299bTlsr        , $88),
     (CStv0299bCfd         , $F7),
     (CStv0299bAclc        , $88),
     (CStv0299bBclc        , $5C),
     (CStv0299bCldt        , $14),
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     (CStv0299bSfrH        , $80),
     (CStv0299bSfrM        , $00),
     (CStv0299bSfrL        , $00),
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     (CStv0299bFecM        , $01),
     (CStv0299bVth0        , $1E),
     (CStv0299bVth1        , $14),
     (CStv0299bVth2        , $0F),
     (CStv0299bVth3        , $09),
     (CStv0299bVth4        , $05),
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     ($FF                  , $00),                         // Not used for setting
     (CStv0299bPr          , $1F),
     (CStv0299bVSearch     , $19),
     (CStv0299bRs          , $F8),
     (CStv0299bErrCnt      , $01));


{------------------------------------------------------------------------------
  Descript:  I2C
 -----------------------------------------------------------------------------}
  CStv0299bI2cRepeaterOn = $80;

{------------------------------------------------------------------------------
  Descript:  OP0/1
 -----------------------------------------------------------------------------}
  CStv0299bOP1Mask  = $C0;
  CStv0299bOP1Value = $40;
  CStv0299bOP0Mask  = $30;
  CStv0299bOP0Value = $10;
  CStv0299bOPMask   = $F0;

{------------------------------------------------------------------------------
  Descript:  DiSEqC/22 kHz
 -----------------------------------------------------------------------------}
  CStv0299bModulation0           = $00;                    // Output '0'
  CStv0299bModulation1           = $01;                    // Output '1'
  CStv0299bModulationUnmodulated = $02;                    // Unmodulated tone burst
  CStv0299bModulationContinuous  = $03;                    // Continuous tone (FIFO data = $00)
  CStv0299bModulationModulated   = $06;                    // Modulated tone burst (FIFO data =$FF/$00)
  CStv0299bModulationDiSEqC      = $06;                    // DiSEqC signal (FIFO data)

  CStv0299bModulationModeMask    = $03;
  CStv0299bModulationMask        = $07;

  CStv0299bFifoMask              = $03;                    // Fifo status mask
  CStv0299bFifoEmpty             = $02;                    // Fifo status indicating fifo empty
  CStv0299bFifoFull              = $01;                    // Fifo status indicating fifo full

  CStv0299bInversion             = $01;                    // Inversion
  CStv0299bAGCInversion          = $80;                    // AGC inversion

  CStv0299bManualSearchMode = $80; // Manual search mode



implementation

end.
