{******************************************************************************}
{ FileName............: FlexCopRegisters                                       }
{ Project.............: FLEXCOP                                                }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Register/constant definitions for the FLEXCOP                               }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20050409 - Initial release                                           }
{ **************************************************************************** }

unit FlexCopRegisters;

interface
uses
  Windows;

const

{------------------------------------------------------------------------------
  Descript: Sub buffers operation
            For buffering purposes the FlexCop can use sub buffers. This means
            that data being received can be placed in two different buffers.
            The FlexCop then switches automatically from one buffer to the other
            when a buffer has been filled. The FlexCop can generate an interrupt
            if it switches to the other buffer.
            Beside an interrupt when a change of buffers is done, there is also
            an interrupt which is activated for every 50 packets (== 9400 bytes)
            received. This is independent of which buffer is being used.

            One drawback of this mechanism used by the FlexCop is that there is
            no way of knowing which buffer is in use/has been used just by the
            interrupt generated. The driver has to look at the address currently
            being used by the FlexCop for buffering to decide which buffer it
            can access safely.
 -----------------------------------------------------------------------------}


{------------------------------------------------------------------------------
  Descript: Register definitions for FLEXCOP.
  Note    : Addresses are 'shadowed' every $20 addresses, so $200 and $220
            are accessing the same location
 -----------------------------------------------------------------------------}
  CFlexCopDma1SubBuffer0Address   = $000;                  // Sub buffer 0 address for DMA1
                                                           // $FFFFFFFC = address (so must be on Dword boundary)
                                                           // $xxxxxxx1 = IRQs subbuffers enabled (both buffer IRQ and packet IRQ)
  CFlexCopDma1SubBufferSize       = $004;                  // Sub buffer size for DMA1
                                                           // $XXXXXXxx = Size in Dwords
                                                           // $xxxxxxx2 = Disable packet IRQs (CFlexCopIrqDma1Packets)
  CFlexCopDma1SubBufferAddress    = $008;                  // Buffer address currently being filled
                                                           // Buffering itself is done in 3 'steps':
                                                           //   2 blocks of 64 bytes and one of 60 bytes (== 188 bytes)
  CFlexCopDma1SubBuffer1Address   = $00C;                  // Sub buffer 1 address for DMA1
                                                           // $FFFFFFC = address (so must be on Dword boundary)
                                                           // $xxxxxx1 = Subbuffer 1 enabled

  CFlexCopDma2SubBuffer0Address   = $010;                  // Sub buffer 0 address for DMA2
  CFlexCopDma2SubBufferSize       = $014;                  // Sub buffer size for DMA2
  CFlexCopDma2SubBufferAddress    = $018;                  // Buffer address currently being filled
  CFlexCopDma2SubBuffer1Address   = $01C;                  // Sub buffer 1 address for DMA2

  CFlexCopI2cControl              = $100;                  // I2C control register
  CFlexCopI2cData                 = $104;                  // I2C data register
  CFlexCopI2cTimingChannel1       = $108;                  // I2C timing channel 1 (Frontend)
  CFlexCopI2cTimingChannel2       = $10C;                  // I2C timing channel 2 (EEPROM)
  CFlexCopI2cTimingChannel3       = $110;                  // I2C timing channel 3 (Tuner)
  CFlexCopReserved114             = $114;
  CFlexCopReserved118             = $118;
  CFlexCopReserved11C             = $11C;

  CFlexCopClock                   = $200;                  // Clock generator setting (LNB tone soft mode)
  CFlexCopPowerAndRevision        = $204;                  // Power setting and revision number
  CFlexCopEnable                  = $208;                  // Enables
  CFlexCopIrqStatus               = $20C;                  // IRQ status
  CFlexCopSpecials                = $210;                  // Specials register (eg. resets)
  CFlexCopReserved214             = $214;
  CFlexCopReserved218             = $218;
  CFlexCopReserved21C             = $21C;

  CFlexCopPidHardwarePidStream12  = $300;                  // Hardware PID filter 0/1; stream 1/2
                                                           // $____XXXX = Filter 0; Stream 1
                                                           // $XXXX____ = Filter 1; Stream 2
  CFlexCopPidHardwarePidPcrPmt    = $304;                  // Hardware PID filter 2/3; PCR/PMT
                                                           // $____XXXX = Filter 2; PCR
                                                           // $XXXX____ = Filter 3; PMT
  CFlexCopPidHardwarePidEmmEcm    = $308;                  // Hardware PID filter 4/5; EMM/ECM
                                                           // $____XXXX = Filter 4; EMM
                                                           // $XXXX____ = Filter 5; ECM
                                                           // $2XXX____ = Activate ECM PID
                                                           // $00004000 = During initialization a value of $4000 is written
                                                           //             to this register for initialization (before checking
                                                           //             RAM size) ????
  CFlexCopHardwarePidMask         = $30C;                  // Group PID/mask
                                                           // $____XXXX = PID
                                                           // $XXXX____ = MASK
  CFlexCopHardwarePidFilterSelect = $310;                  // Select additional hardware PID filters (0..31)
  CFlexCopHardwarePidFilterPid    = $314;                  // PID for PID filter as selected by <CFlexCopHardwarePidFilterSelect>
  CFlexCopReserved318             = $318;
  CFlexCopReserved31C             = $31C;

  CFlexCopReserved400             = $400;
  CFlexCopReserved408             = $408;
  CFlexCopReserved40C             = $40C;
  CFlexCopMacAddressLow           = $418;
  CFlexCopMacAddressHigh          = $41C;

  CFlexCopReserved500             = $500;
  CFlexCopReserved504             = $504;
  CFlexCopReserved508             = $508;
  CFlexCopReserved50C             = $50C;
  CFlexCopReserved510             = $510;
  CFlexCopReserved514             = $514;
  CFlexCopReserved518             = $518;
  CFlexCopReserved51C             = $51C;

  CFlexCopReserved600             = $600;
  CFlexCopReserved604             = $604;
  CFlexCopReserved608             = $608;
  CFlexCopReserved60C             = $60C;
  CFlexCopReserved610             = $610;
  CFlexCopReserved614             = $614;
  CFlexCopReserved618             = $618;
  CFlexCopReserved61C             = $61C;

  CFlexCopMemoryControl           = $700;
  CFlexCopReserved704             = $704;
  CFlexCopReserved708             = $708;
  CFlexCopReserved70C             = $70C;
  CFlexCopReserved710             = $710;
  CFlexCopMemorySelect            = $714;
  CFlexCopReserved718             = $718;
  CFlexCopMemorySize              = $71C;                  // Ram size

{------------------------------------------------------------------------------
  Descript:  <CFlexCopDmaXSubBufferXAddress>
             <CFlexCopDmaXSubBufferSize>
 -----------------------------------------------------------------------------}
  CFlexCopSubBufferAddress          = $FFFFFFFC;             // Address only part
  CFlexCopSubBufferSize             = $FFFFFF00;             // Size only part
  CFlexCopSubBufferEnableIrq        = $00000001;             // Enable IRQs for subbuffers
  CFlexCopSubBufferEnableSubBuffer1 = $00000001;             // Enable subbuffer 1
  CFlexCopSubBufferDisablePacketIrq = $00000002;             // Disable packet interrupts


{------------------------------------------------------------------------------
  Descript:  <CFlexCopI2cControl>
  bit  1098 7654 3210 9876 5432 1098 7654 3210
       3322 2222 2222 1111 1111 11
       X                                          [R]   (1) Ready (transmission done)
                                                  [W]   Reserved
        X                                         [R]   (1) ACK error (no acknowledge received)
                                                  [W]   Base address presence indicator
                                                        (1) = no base address generated (for reading operations)
                                                        (0) = base address is generated (bits 0-7)
         XX                                       [R/W] Channel (port)
                                                        00 = Reserved
                                                        01 = FrontEnd
                                                        10 = EEPROM
                                                        11 = Tuner
            XX                                    [R/W] Length (bytes-1) of transmission
              X                                   [R/W] First bit of transmisison (=R/W indication)
                                                        (1) Read
                                                        (0) Write
               X                                  [R]   Busy status
                                                        (1) Busy
                                                        (0) Done
                                                  [W]   Start transmission
                 XXXX XXXX                        [R/W] I2C second byte (DATA1)
                           XXXX XXXX              [R/W] I2C first byte  (base address)
                                                        See bit 30
                                     XXXX XXXX    [R]   I2C address (full base address, incl first bit which is bit 24)
                                     0XXX XXXX    [W]   I2C address (highest 7 bits of I2C base address)
 -----------------------------------------------------------------------------}
  CFlexCopI2cReset                = $00000000;             // Clear/reset
  CFlexCopI2cReady                = $80000000;             // Ready
  CFlexCopI2cNoAcknowledge        = $40000000;             // No acknowledge received (1)
  CFlexCopI2cReadOperation        = $02000000;             // Read operation
  CFlexCopI2cWriteOperation       = $00000000;             // Write operation
  CFlexCopI2cBusy                 = $01000000;             // Busy
  CFlexCopI2cStart                = $01000000;             // Start transmission

  CFlexCopI2cChannel              = $30000000;             // I2C channel
  CFlexCopI2cChannelAnd           = $3;                    // I2C channel valid bits
  CFlexCopI2cChannelShift         = 28;                    // I2C channel shift
  CFlexCopI2cChannelFlexCop       = $0;                    // FlexCop 'channel' (invalid!)
  CFlexCopI2cChannelFrontEnd      = $1;                    // FrontEnd channel
  CFlexCopI2cChannelEeprom        = $2;                    // EEPROM channel
  CFlexCopI2cChannelTuner         = $3;                    // Tuner channel

  CFlexCopI2cWriteLength          = $0C000000;             // Length of data to write
  CFlexCopI2cWriteLengthAnd       = $3;                    // Length of data to write shift valid bits
  CFlexCopI2cWriteLengthShift     = 26;                    // Length of data to write shift

  CFlexCopI2c2ndByte              = $00FF0000;             // I2C 2nd byte read/written
  CFlexCopI2c2ndByteAnd           = $FF;                   // I2C 2nd byte read/written valid bits
  CFlexCopI2c2ndByteShift         = 16;                    // I2C 2nd byte read/written shift

  CFlexCopI2c1stByte              = $0000FF00;             // I2C 1st byte read/written
  CFlexCopI2c1stByteAnd           = $FF;                   // I2C 1st byte read/written valid bits
  CFlexCopI2c1stByteShift         = 8;                     // I2C 1st byte read/written shift

  CFlexCopI2cAddress              = $0000007F;             // I2C address
  CFlexCopI2cAddressAnd           = $FE;                   // I2C address valid bits
  CFlexCopI2cAddressShift         = 1;                     // I2C address shift

  // EEPROM
  // The EEPROM is a 24LC08 chip (1 kB)
  // Note: The EEPROM can not be read if all powers are off
  CFlexCopI2cAddressEepromWrite     = $A0;                 // I2C address EEPROM write operation
  CFlexCopI2cAddressEepromRead      = $A1;                 // I2C address EEPROM read operation
  CFlexCopI2cAddressEepromHigh      = $0E;                 // High register address bits (A10/A9/A8)
  CFlexCopI2cAddressEepromHighAnd   = $07;                 // High register address bits valid bits
  CFlexCopI2cAddressEepromHighShift = 1;                   // High register address bits shift

  // Index (addresses) in EEPROM
  CFlexCopI2cEepromB2c2Address       = $000;               // Index (address) containing 'B2C2' identification
  CFlexCopI2cEepromB2c2AddressBytes  = 2;                  // Number of bytes making up the identification
  CFlexCopI2cEepromMacAddress        = $3F8;               // Index (address) containing MAC address of card
  CFlexCopI2cEepromMacAddressBytes   = 8;                  // Number of bytes making up the address
  CFlexCopI2cEepromTunerAddress      = $3E0;               // Index (address) containing tuner type
  CFlexCopI2cEepromTunerAddressBytes = 4;                  // Number of bytes making up the tuner type
  CFlexCopI2cEepromKeyAddress        = $3E4;               // Index (address) containing keys
  CFlexCopI2cEepromKeyAddressBytes   = 20;                 // Number of bytes making up the address

{------------------------------------------------------------------------------
  Descript:  <CFlexCopI2cData>
  bit  1098 7654 3210 9876 5432 1098 7654 3210
       3322 2222 2222 1111 1111 11
       XXXX XX                                          Reserved
              X                                   [W]   (1) Generate STOP event (FLEXCOPIII only)
               X                                  [W]   (1) Explicit stop (no trailing STOP in transmission generated, FLEXCOPIII only)
                 XXXX XXXX                        [R/W] Fifth byte   (DATA4)
                           XXXX XXXX              [R/W] Fourth byte  (DATA3)
                                     XXXX XXXX    [R/W] Third byte   (DATA2)
 -----------------------------------------------------------------------------}

{------------------------------------------------------------------------------
  Descript:  <CFlexCopI2cTimingChannelX>
  bit  1098 7654 3210 9876 5432 1098 7654 3210
       3322 2222 2222 1111 1111 11
       XXXX XXXX XXXX XXXX XXX                          Reserved
                              X XXXX              [R/W] Low time  (prescaled internal clock as reference)
                                     XX                 Reserved
                                       XX XXXX    [R/W] High time (prescaled internal clock as reference)
 -----------------------------------------------------------------------------}


{------------------------------------------------------------------------------
  Descript:  <CFlexCopClock>
 -----------------------------------------------------------------------------}
  CFlexCopClockRevII              = 45000000;              // FlexCop II clock
  CFlexCopClockRevIII             = 48000000;              // FlexCop III clock
  CFlexCopPrescalerDefault        = $40000000;             // Default prescaler = 4
  CFlexCopPrescalerDefaultvalue   = 4;                     // Default prescaler = 4
  CFlexCopClockLowMask            = $3FFF8000;             // Low part clock  (off time)
  CFlexCopClockHighMask           = $00007FFF;             // High part clock (on time)
  CFlexCopClockOff                = $40FF8000;             // Output of clock 'off'
  CFlexCopClock22kHzII            = ((CFlexCopClockRevII  div CFlexCopPrescalerDefaultValue) div 22000);
  CFlexCopClock22kHzIII           = ((CFlexCopClockRevIII div CFlexCopPrescalerDefaultValue) div 22000);
  // Next are the actual clock settings to use: a 50% duty cycle
  CFlexCopClockSet22kHzII         = CFlexCopPrescalerDefault or (CFlexCopClock22kHzII  shl 15) or CFlexCopClock22kHzII;
  CFlexCopClockSet22kHzIII        = CFlexCopPrescalerDefault or (CFlexCopClock22kHzIII shl 15) or CFlexCopClock22kHzIII;

{------------------------------------------------------------------------------
  Descript:  <CFlexCopPowerAndRevision>
 -----------------------------------------------------------------------------}
  CFlexCopTunerPowerMask          = $00000001;             // Tuner/LNB power mask
  CFlexCopTunerPowerOff           = $00000001;             // Tuner/LNB power OFF
  CFlexCopTunerPowerOn            = $00000000;             // Tuner/LNB power ON
                                                           // Note: When switching power off and on to 'reset'
                                                           //       the tuner then a delay of about 700 ms is
                                                           //       required (unloaded situation)
  CFlexCopSystemPowerMask         = $00000002;             // System power mask
  CFlexCopSystemPowerOff          = $00000002;             // System power OFF
  CFlexCopSystemPowerOn           = $00000000;             // System power ON
  CFlexCopLnbPolarityMask         = $00000004;             // LNB polarity mask
  CFlexCopLnbPolarityHorizontal   = $00000004;             // LNB horizontal polarity (18V)
  CFlexCopLnbPolarityVertical     = $00000000;             // LNB vertical polarity   (13V)
  CFlexCopWakeUpMask              = $00000008;             // Wake up mask
  CFlexCopWakeUpOff               = $00000000;             // Wake up OFF
  CFlexCopWakeUpOn                = $00000008;             // Wake up ON
  CFlexCopBoardReset              = $FFFFFFF7;             // Powers off
  CFlexCopBoardResetPowerOn       = $FFFFFF00;             // Powers on
  CFlexCopRevisionMask            = $FF000000;             // Revision mask
                                                           // $40 =             rev 064
                                                           // $82 = FLEXCOP II  rev 130 -> 45 MHz clock
                                                           // $C0 = FLEXCOP III rev 192 -> 48 MHz clock
                                                           // $C2 =             rev 194
                                                           // $C3 = FLEXCOP IIB rev 195 -> 45 MHz clock
  CFlexCopRevisionShift           = 24;                    // Revision shift
  CFlexCopRevisionAnd             = $FF;                   // Valid bits

{------------------------------------------------------------------------------
  Descript:  <CFlexCopEnable>
 -----------------------------------------------------------------------------}
  CFlexCopEnableAllFilters        = $0000003F;             // All filters enabled
  CFlexCopEnableStream1           = $00000001;             // Enable hardware PID filter 0; stream 1
  CFlexCopEnableStream2           = $00000002;             // Enable hardware PID filter 1; stream 2
  CFlexCopEnablePcr               = $00000004;             // Enable hardware PID filter 2; PCR
  CFlexCopEnablePmt               = $00000008;             // Enable hardware PID filter 3; PMT
  CFlexCopEnableEmm               = $00000010;             // Enable hardware PID filter 4; EMM
  CFlexCopEnableEcm               = $00000020;             // Enable hardware PID filter 5; ECM
  CFlexCopEnableNull              = $00000040;             // Enable null filter
  CFlexCopEnableMask              = $00000080;             // Enable mask filter
  CFlexCopEnableWan               = $00000100;             // Enable WAN
  CFlexCopEnableWanCa             = $00000200;             // Enable WAN Conditional Access
  CFlexCopEnableCa                = $00000400;             // Enable Conditional Access
  CFlexCopEnableSmc               = $00000800;             // Enable SMC
  CFlexCopEnablePerCa             = $00001000;             // Enable PER CA
  CFlexCopEnableMulti             = $00002000;             // Enable MULTI
  CFlexCopEnableMac               = $00004000;             // Enable MAC
  CFlexCopEnableReceive           = $00008000;             // Enable receive data
  CFlexCopEnableAllDma            = $000F0000;             // Enable DMA's
  CFlexCopEnableDma10             = $00010000;             // Enable DMA 1, sub buffer 0
  CFlexCopEnableDma11             = $00020000;             // Enable DMA 1, sub buffer 1
  CFlexCopEnableDma20             = $00040000;             // Enable DMA 2, sub buffer 0
  CFlexCopEnableDma21             = $00080000;             // Enable DMA 2, sub buffer 1

{------------------------------------------------------------------------------
  Descript:  <CFlexCopIrqStatus>
 -----------------------------------------------------------------------------}
  CFlexCopIrqAllDma               = $0000000F;             // Status all DMA's
  CFlexCopIrqDma1Buffer           = $00000001;             // Status DMA 1, switching from sub buffer (CFlexCopDma1SubBufferAddress indicates current address being used)
  CFlexCopIrqDma1Packets          = $00000002;             // Status DMA 1, packet interrupt (interrupts for every 50 packets received == 9400 bytes)
  CFlexCopIrqDma2Buffer           = $00000004;             // Status DMA 2, switching from sub buffer (CFlexCopDma2SubBufferAddress indicates current address being used)
  CFlexCopIrqDma2Packets          = $00000008;             // Status DMA 2, packet interrupt (interrupts for every 50 packets received == 9400 bytes)
  CFlexCopHwError                 = $000000F0;             // ?? Status hardware errors
  CFlexCopHwError1                = $00000010;             // ?? Status hardware error $10000000
  CFlexCopHwError2                = $00000020;             // ?? Status hardware error $20000000
  CFlexCopHwError3                = $00000040;             // ?? Status hardware error $40000000
  CFlexCopHwError4                = $00000080;             // ?? Status hardware error $80000000
  CFlexCopHwErrorCa               = $00000F00;             // ?? Status error CA
  // Irq numbers (bit number)
  CFlexCopIrqDma10Irq             = 0;                     // Status DMA 1, switching from sub buffer (CFlexCopDma1SubBufferAddress indicates current address being used)
  CFlexCopIrqDma11Irq             = 1;                     // Status DMA 1, packet interrupt (interrupts for every 50 packets received == 9400 bytes)
  CFlexCopIrqDma20Irq             = 2;                     // Status DMA 2, switching from sub buffer (CFlexCopDma2SubBufferAddress indicates current address being used)
  CFlexCopIrqDma21Irq             = 3;                     // Status DMA 2, packet interrupt (interrupts for every 50 packets received == 9400 bytes)
  CFlexCopHwError1Irq             = 4;                     // ?? Status hardware error $10000000
  CFlexCopHwError2Irq             = 5;                     // ?? Status hardware error $20000000
  CFlexCopHwError3Irq             = 6;                     // ?? Status hardware error $40000000
  CFlexCopHwError4Irq             = 7;                     // ?? Status hardware error $80000000

{------------------------------------------------------------------------------
  Descript:  <CFlexCopSpecials>
 -----------------------------------------------------------------------------}
  CFlexCopSpecialReset            = $B2FF;                 // Reset
  CFlexCopSpecialReset300         = $B208;                 // Reset $300 memory block
  CFlexCopSpecialReset700         = $B280;                 // Reset $700 memory block

{------------------------------------------------------------------------------
  Descript:  <CFlexCopPidFromStream>
 -----------------------------------------------------------------------------}
  CFlexCopPidFromStream1          = $0000FFFF;             // Mask to get PID from stream 1
  CFlexCopPidFromStream2          = $FFFF0000;             // Mask to get PID from stream 2 (needs shift)

{------------------------------------------------------------------------------
  Descript:  <CFlexCopPidMask>
 -----------------------------------------------------------------------------}
  CFlexCopPidMaskPidGroup         = $00003FFF;             // Mask for GROUP PID (typically set before setting mask)
  CFlexCopPidMaskPidMask          = $3FFF0000;             // Mask for MASK PID
                                                           // Note: When setting mask to $1FE0 then
                                                           //       only PIDs $00..$1F will pass through the selected group

{------------------------------------------------------------------------------
  Descript:  <CFlexCopHardwarePidFilterSelect>
 -----------------------------------------------------------------------------}
  CFlexCopPidFilter0              = $0000001A;             // Select HW PID filter 0
  CFlexCopPidFilter1              = $0000001B;             // Select HW PID filter 1
  CFlexCopPidFilter2              = $0000001C;             // Select HW PID filter 2
  CFlexCopPidFilter3              = $0000001D;             // Select HW PID filter 3
  CFlexCopPidFilter4              = $0000001E;             // Select HW PID filter 4
  CFlexCopPidFilter5              = $0000001F;             // Select HW PID filter 5

{------------------------------------------------------------------------------
  Descript:  <CFlexCopMemoryControl>
 -----------------------------------------------------------------------------}
  CFlexCopMemoryAddress           = $00007FFF;             // Address into RAM
  CFlexCopMemoryControlWrite      = $04000000;             // For writing
  CFlexCopMemoryRW                = $00008000;             // Read/Write flag
  CFlexCopMemoryRead              = $00008000;             // Read flag
  CFlexCopMemoryWrite             = $00000000;             // Write flag
  CFlexCopMemoryByteWrite         = $00FF0000;             // Byte to write
  CFlexCopMemoryByteWriteShift    = 16;                    // Byte to write shifts
  CFlexCopMemoryBankShift         = 28;                    // Memory bank shifts
  CFlexCopMemoryBankSelect        = $30000000;             // Memory bank
  CFlexCopMemoryBankSelect0       = $00000000;             // Memory bank 0 ($00000-$07FFF)
  CFlexCopMemoryBankSelect1       = $10000000;             // Memory bank 1 ($08000-$0FFFF)
  CFlexCopMemoryBankSelect2       = $20000000;             // Memory bank 2 ($10000-$17FFF)
  CFlexCopMemoryBankSelect3       = $30000000;             // Memory bank 3 ($18000-$1FFFF)
  CFlexCopMemoryBusy              = $80000000;             // Busy flag

{------------------------------------------------------------------------------
  Descript:  <CFlexCopMemorySelect>
 -----------------------------------------------------------------------------}
  CFlexCopMemorySelectNet         = $00000003;             // Select destination NET     (typically set to 1)
  CFlexCopMemorySelectNetShift    = 0;
  CFlexCopMemorySelectCaIn        = $0000000C;             // Select destination CA in   (typically set to 2)
  CFlexCopMemorySelectCaInShift   = 2;
  CFlexCopMemorySelectCaOut       = $00000030;             // Select destination CA out  (typically set to 2)
  CFlexCopMemorySelectCaOutShift  = 4;
  CFlexCopMemorySelectMedia       = $000000C0;             // Select destination MEDIA   (typically set to 1)
  CFlexCopMemorySelectMediaShift  = 6;
  CFlexCopMemorySelect1           = $00000001;             // Set destination ...
  CFlexCopMemorySelect2           = $00000002;             // Set destination ...
                                                           // %01 = destination 0
                                                           // %10 = destination 1


{------------------------------------------------------------------------------
  Descript:  <CFlexCopMemorySize>
 -----------------------------------------------------------------------------}
  CFlexCopMemoryInternalCheck     = $00000001;             // Check for internal/external RAM ?
  CFlexCopMemoryInternal          = $00000000;             // Internal memory ?
  CFlexCopMemorySize64k           = $00000000;             // 64K, bank 1, 2
  CFlexCopMemorySize32k           = $00010000;             // 32K, bank 0
  CFlexCopMemorySize128k          = $00020000;             // 128K, bank 0, 1, 2, 3
  CFlexCopMemorySizeMask          = $00030000;             // Mask for size

implementation

end.

