{******************************************************************************}
{ FileName............: WriteRegisterFlexCop                                   }
{ Project.............: FLEXCOP                                                }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Write to FLEXCOP register                                                   }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Usage:                                                                       }
{    programname register data                                                 }
{ Result is in exit code:                                                      }
{    $0000 = No error                                                          }
{    $01xx = Invalid number of parameters                                      }
{    $02xx = First parameter incorrect                                         }
{    $03xx = 2nd parameter incorrect                                           }
{    $04xx = 3rd parameter incorrect                                           }
{    $05xx = etc                                                               }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040515 - Initial release                                           }
{******************************************************************************}
program WriteRegisterFlexCop;

uses
  Windows,
  FlexCopInterface;

var
  CardHandle    : THandle;
  AccessRegister: Dword;
  Value         : Dword;
  Error         : Integer;
begin
  if ParamCount <> 2 then
    Halt($0100);
  Val(ParamStr(1), AccessRegister, Error);
  if Error <> 0 then
    Halt($0200);
  // Check for latest register address
  if AccessRegister >= $800 then
    Halt($0200);
  // Must be on 4 byte boundary
  if (AccessRegister mod 4) <> 0 then
    Halt($0200);
  // Must be in $x00.. $x1C range
  if (AccessRegister and $FF) > $1C then
    Halt($0200);
  Val(ParamStr(2), Value, Error);
  if Error <> 0 then
    Halt($0300);
  if FlexCopGetNumberOfCards = 0 then
    Halt($1000);
  // Note: We can not use a HALT from this point on because the ..finally..
  //       part of the try..finally is then NOT executed!
  Error := $2000;
  CardHandle := FlexCopCreateFile(-1);
  try
    if FlexCopWriteToFlexCopRegister(CardHandle, AccessRegister, Value) then
      Error := $0000;
  finally
    FlexCopCloseHandle(CardHandle);
    Halt(Error);
  end;
end.
