{******************************************************************************}
{ FileName............: DumpRegistersFlexCop                                   }
{ Project.............: FLEXCOP                                                }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Dump FLEXCOP registers to file                                              }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ By default uses FLEXCOP.TXT as file                                          }
{ Use command line parameter to define another file                            }
{ Result is also in exit code:                                                 }
{    $0000 = No error                                                          }
{    $01xx = Invalid number of parameters                                      }
{    $02xx = First parameter incorrect                                         }
{    $03xx = 2nd parameter incorrect                                           }
{    $04xx = 3rd parameter incorrect                                           }
{    $05xx = etc                                                               }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20040515 - Initial release                                           }
{******************************************************************************}
program DumpRegistersFlexCop;

uses
  SysUtils,
  Windows,
  FlexCopInterface;

var
  CardHandle   : THandle;
  FileName     : string;
  OutputFile   : Text;
  Loop         : Integer;
  Loop2        : Integer;
  ReturnedDword: Dword;
  Error        : Integer;
begin
  Error := $2000;
  FileName := 'FLEXCOP.TXT';
  if ParamCount > 0 then
    FileName := ParamStr(1);
  AssignFile(OutputFile, FileName);
  try
    Rewrite(OutputFile);
    if FlexCopGetNumberOfCards = 0 then
    begin
      WriteLn(OutputFile, 'No FLEXCOP driver/card detected');
      Error := $1000;
      Exit;
    end;
    CardHandle := FlexCopCreateFile(-1);
    try
      WriteLn(OutputFile, 'Contents of FLEXCOP (' + FormatDateTime('', Now) + ')');
      WriteLn(OutputFile);
      for Loop2 := 0 to 7 do
      begin
        for Loop := 0 to 7 do
        begin
          if not FlexCopReadFromFlexCopRegister(CardHandle, (Loop2 * $100) + Loop * 4, ReturnedDword) then
          begin
            WriteLn(OutputFile, 'Error reading FLEXCOP register');
            Exit;
          end;
          WriteLn(OutputFile, format('Register $%3.3x == $%8.8x', [(Loop2 * $100) + Loop * 4, ReturnedDword]));
        end;
        WriteLn(OutputFile);
      end;
      Error := $0000;
    finally
      FlexCopCloseHandle(CardHandle);
    end;
  finally
    CloseFile(OutputFile);
    Halt(Error);
  end;
end.
