{******************************************************************************}
{ FileName............: DumpEepromFlexCop                                      }
{ Project.............: FLEXCOP                                                }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Dump FLEXCOP EEPROM contents to file                                        }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ By default uses FLEXCOP.TXT as file                                          }
{ Use command line parameter to define another file                            }
{ Result is also in exit code:                                                 }
{    $0000 = No error                                                          }
{    $01xx = Invalid number of parameters                                      }
{    $02xx = First parameter incorrect                                         }
{    $03xx = 2nd parameter incorrect                                           }
{    $04xx = 3rd parameter incorrect                                           }
{    $05xx = etc                                                               }
{    $10xx = Driver/card not available                                         }
{    $20xx = Operation failed                                                  }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   2004052 - Initial release                                           }
{******************************************************************************}
program DumpEepromFlexCop;

uses
  SysUtils,
  Windows,
  FlexCopInterface,
  FlexCopI2c;

var
  CardHandle   : THandle;
  FileName     : string;
  NewStr       : string;
  OutputFile   : Text;
  Loop         : Integer;
  Loop2        : Integer;
  Error        : Integer;
  Data         : array[0..15] of Byte;
begin
  Error := $2000;
  FileName := 'EEPROM.TXT';
  if ParamCount > 0 then
    FileName := ParamStr(1);
  AssignFile(OutputFile, FileName);
  try
    Rewrite(OutputFile);
    if FlexCopGetNumberOfCards = 0 then
    begin
      WriteLn(OutputFile, 'No FLEXCOP driver/card detected');
      Error := $1000;
      Exit;
    end;
    CardHandle := FlexCopCreateFile(-1);
    try
      WriteLn(OutputFile, 'Contents of FLEXCOP EEPROM (' + FormatDateTime('', Now) + ')');
      WriteLn(OutputFile);
      for Loop := 0 to 63 do
      begin
        if not FlexCopI2cReadEeprom(CardHandle, (Loop * $10), Data) then
        begin
          WriteLn(OutputFile, 'Error reading FLEXCOP EEPROM');
          Exit;
        end;
        NewStr := '';
        for Loop2 := 0 to 15 do
          NewStr := NewStr + format('%2.2x', [Data[Loop2]]);
        WriteLn(OutputFile, format('$%3.3x == %s', [Loop * $10, NewStr]));
      end;
      WriteLn(OutputFile);
      Error := $0000;
    finally
      FlexCopCloseHandle(CardHandle);
    end;
  finally
    CloseFile(OutputFile);
    Halt(Error);
  end;
end.
