{******************************************************************************}
{ FileName............: ShowingStreamDataUnit001                               }
{ Project.............: FlexCop                                                }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Buffering / Showing streams.                                                }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{ Includes master / slave principle for multiple instances which will use the  }
{ same packet data.                                                            }
{                                                                              }
{ The default settings should provide you with a video/audio/PMT of the german }
{ ARD program being transmitted. It is assumed the dish is facing Astra 19.2E  }
{ and that the PIDs have not changed....                                       }
{ If no video/audio is shown (without an error being reported) then check the  }
{ graphics setup (see note below).                                             }
{                                                                              }
{ Note: Master / Slave operation for DirectShow currently generates an error   }
{       at the second instance (slave)                                         }
{ Note: Only one DirectShow per process can be run ....                        }
{ Note: Debug not always possible because of DirectShow stuff ...              }
{ Note: Stream decoding not active ...                                         }
{ Note: The supplied VIDEO.GRF has no connected output pins. This is not       }
{       absolute necessary because these are automatically connected to the    }
{       'correct' video/audio filters.                                         }
{       These video/audio filters are typically part of a DVD viewer (like     }
{       InterVideo / PowerDVD etc. You can also connect these pins as required }
{       so they are forced to a specific connection. You need the FilterGraph  }
{       from DirectX 9 for this.                                               }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20050416 - Initial DLL release                                       }
{******************************************************************************}
unit ShowingStreamDataUnit001;

// Note: For debugging WITHOUT the DLL you need to add a path to additional
//       source code ....
{$DEFINE USEDLL}

interface
uses
{$IFNDEF USEDLL}
  UFlexCopFrontEnd,
{$ENDIF}
  Forms, ExtCtrls, StdCtrls, Mask, Controls, Classes, Gauges;

type
  TfrmMain = class(TForm)
    btnExit: TButton;
    mmoDriver: TMemo;
    rgPolarity: TRadioGroup;
    mskSymbolRate: TMaskEdit;
    StaticText1: TStaticText;
    tmrUpdate: TTimer;
    StaticText3: TStaticText;
    mskFrequency: TMaskEdit;
    txtSignalPower: TStaticText;
    txtSignalState: TStaticText;
    txtNoiseIndicator: TStaticText;
    txtPacketCount: TStaticText;
    StaticText29: TStaticText;
    StaticText5: TStaticText;
    StaticText6: TStaticText;
    StaticText8: TStaticText;
    mskVideoPid: TMaskEdit;
    mskAudioPid: TMaskEdit;
    StaticText9: TStaticText;
    StaticText10: TStaticText;
    pnlVideo: TPanel;
    mskPmtPid: TMaskEdit;
    StaticText11: TStaticText;
    StaticText12: TStaticText;
    grpDiSEqC: TGroupBox;
    btnSat1: TButton;
    cmbRepeats: TComboBox;
    StaticText2: TStaticText;
    btnSat3: TButton;
    btnSat2: TButton;
    btnSat4: TButton;
    ggPower: TGauge;
    ggNoise: TGauge;
    procedure btnExitClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure rgPolarityClick(Sender: TObject);
    procedure mskSymbolRateChange(Sender: TObject);
    procedure tmrUpdateTimer(Sender: TObject);
    procedure mskFrequencyChange(Sender: TObject);
    procedure mskFrequencyKeyPress(Sender: TObject; var Key: Char);
    procedure mskSymbolRateKeyPress(Sender: TObject; var Key: Char);
    procedure mskPidChange(Sender: TObject);
    procedure mskPidKeyPress(Sender: TObject; var Key: Char);
    procedure FormDestroy(Sender: TObject);
    procedure FrontEndChange(Sender: TObject);
    procedure btnSat1Click(Sender: TObject);
    procedure btnSat2Click(Sender: TObject);
    procedure btnSat3Click(Sender: TObject);
    procedure btnSat4Click(Sender: TObject);
  private
    { Private declarations }
    procedure SatSelect(Sender: TObject; Satellite: Integer);
  public
    { Public declarations }
  end;


var
  frmMain: TfrmMain;

implementation

{$R *.DFM}

uses
  SyncObjs,
  Windows, Messages, SysUtils, Graphics, Dialogs,
  DvbDirectShow, FlexCopFrontEndDefines, FlexCopDemuxDefines;

var
{$IFDEF USEDLL}
  FrontEndOpen     : TFlexCopOpen;
  FrontEndClose    : TFlexCopClose;
  FrontEndIoCtl    : TFlexCopIoCtl;
{$ENDIF}
  FrontEndDllHandle: THandle;
  DemuxIoCtl       : TFlexCopIoCtl;
  DemuxDllHandle   : THandle;

  FrontEndHandle   : THandle;

  AudioPid         : Word;
  AudioPidCount    : Word;
  VideoPid         : Word;
  VideoPidCount    : Word;
  PmtPid           : Word;
  PmtPidCount      : Word;
  PatPidCount      : Word;

  Counts           : Word;

  ShowVideo        : Boolean;                           // True shows video


{------------------------------------------------------------------------------
  Params  : <Buffer>      Pointer to data
            <DataLength>  Length of buffer (always 188 though)
  Returns : <Result>      Not used

  Descript: Here we receive the packet data
  Notes   :
 ------------------------------------------------------------------------------}
function DataCallback(Buffer: PByteArray; DataLength: Integer): Integer; stdcall;
var
  Pid: Word;
begin
  Result := 0;
  if Counts = $FFFF then
    Counts := 0
  else
    Inc(Counts);
  // For debugging also note the PIDs coming by ....
  Pid := ((Buffer[1] and $1F) shl 8) or Buffer[2];
  if Pid = AudioPid then
    if AudioPidCount = $FFFF then
      AudioPidCOunt := 0
    else
      Inc(AudioPidCount);
  if Pid = VideoPid then
    if VideoPidCount = $FFFF then
      VideoPidCOunt := 0
    else
      Inc(VideoPidCount);
  if Pid = PmtPid then
    if PmtPidCount = $FFFF then
      PmtPidCOunt := 0
    else
      Inc(PmtPidCount);
  if Pid = 0 then
    if PatPidCount = $FFFF then
      PatPidCOunt := 0
    else
      Inc(PatPidCount);

  DirectShowUniversalSourceSendData(Pointer(Buffer), DataLength);
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Creation of form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormCreate(Sender: TObject);
var
  ErrorMessage: string;
begin
  cmbRepeats.ItemIndex := 1;
  // We use the tag for the returned identifier
  if not DirectShowStart(frmMain.pnlVideo.Handle, 'VIDEO.GRF', False, False, False, ErrorMessage, INVALID_HANDLE_VALUE) then
    frmMain.mmoDriver.Lines.Add('DirectShow error')
  else
  begin
    frmMain.MskPidChange(nil);  // Send PID info to DirectShow
    ShowVideo := True;
  end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Form destruction.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  // Note: We MUST make sure that <DSSendDataDirect> is never called when DirectShow
  //       has stopped, therefore we inform the thread
  ShowVideo := False;
  Sleep(1);

  DirectShowStop;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>  Sender
  Returns : -

  Descript: Exit application.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmMain.btnExitClick(Sender: TObject);
begin
  Application.Terminate;
end;


procedure TfrmMain.rgPolarityClick(Sender: TObject);
var
  Result: Integer;
begin
{$IFDEF USEDLL}
  case rgPolarity.ItemIndex of
    0:   Result := FrontEndIoCtl(FrontEndHandle, FE_SET_VOLTAGE, Pointer(SEC_VOLTAGE_18));
    1:   Result := FrontEndIoCtl(FrontEndHandle, FE_SET_VOLTAGE, Pointer(SEC_VOLTAGE_13));
    else Result := 0;
  end;
{$ELSE}
  case rgPolarity.ItemIndex of
    0:   Result := UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_SET_VOLTAGE, Pointer(SEC_VOLTAGE_18));
    1:   Result := UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_SET_VOLTAGE, Pointer(SEC_VOLTAGE_13));
    else Result := 0;
  end;
{$ENDIF}
  if Result < 0 then
    mmoDriver.Lines.Add('Unable to set voltage.');
end;


procedure TfrmMain.FrontEndChange(Sender: TObject);
const
  LNBLOFLowBand  = 9750;
  LNBLOFHighBand = 10600;
  LowestTunerFrequency  =  950000;                // Lowest frequency tuner: CAN ALSO BE RETRIEVED USING THE CAPABILITIES CALL
  HighestTunerFrequency = 2150000;                // Highest frequency tuner: CAN ALSO BE RETRIEVED USING THE CAPABILITIES CALL
var
  SymbolRate       : Integer;
  Frequency        : Integer;
  ActualFrequency  : Integer;
  Error            : Integer;
  Result           : Integer;
  FrontEndParameter: TDvbFrontEndParameters;
  LowBand          : Boolean;
begin
  Val(mskSymbolRate.EditText, SymbolRate, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Could not convert symbolrate.');
    Exit;
  end;
  Val(mskFrequency.EditText, Frequency, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Conversion error frequency.');
    Exit;
  end;
  // The frequency we have now is NOT the frequency for the tuner.
  // The frequency should be corrected with the LOF (local oscillator frequency)
  // of the LNB used. Also a typical LNB has two of these LOF's. The
  // selection of the LOF the LNB uses is through the 22 kHz signal:
  // low band == no 22 kHz signal; high band == 22 kHz signal

  // The actual frequency to set is the requested frequency (demodulated!)
  // with the local oscillator (modulation frequency) of the LNB which is
  // either the low band or the high band.
  LowBand := True;
  // Note: The <Abs> allows for negative results (eg. C-band)
  ActualFrequency := Frequency;
  ActualFrequency := Abs(ActualFrequency - LNBLOFLowBand);
  ActualFrequency := ActualFrequency * 1000;
  if ActualFrequency > HighestTunerFrequency then
  begin
    LowBand := False;
    // Note: The <Abs> allows for negative results (eg. C-band)
    ActualFrequency := Frequency;
    ActualFrequency := Abs(ActualFrequency - LNBLOFHighBand);
    ActualFrequency := ActualFrequency * 1000;
  end;
  if (ActualFrequency > HighestTunerFrequency)  or
     (ActualFrequency < LowestTunerFrequency) then
    Exit;
  // Now the band is know we have to set this.
{$IFDEF USEDLL}
  if LowBand then
    FrontEndIoCtl(FrontEndHandle, FE_SET_TONE, Pointer(SEC_TONE_OFF))
  else
    FrontEndIoCtl(FrontEndHandle, FE_SET_TONE, Pointer(SEC_TONE_ON));
{$ELSE}
  if LowBand then
    UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_SET_TONE, Pointer(SEC_TONE_OFF))
  else
    UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_SET_TONE, Pointer(SEC_TONE_ON));
{$ENDIF}

  FrontEndParameter.Frequency       := ActualFrequency;
  FrontEndParameter.Inversion       := INVERSION_AUTO;
  FrontEndParameter.Qpsk.FecInner   := FEC_AUTO;
  FrontEndParameter.Qpsk.SymbolRate := SymbolRate * 1000;  // Symbols per second
{$IFDEF USEDLL}
  Result := FrontEndIoCtl(FrontEndHandle, FE_SET_FRONTEND, @FrontEndParameter);
{$ELSE}
  Result := UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_SET_FRONTEND, @FrontEndParameter);
{$ENDIF}
  if Result < 0 then
    mmoDriver.Lines.Add(format('Unable to set frequency / symbolrate (%d).', [Result]));
end;


procedure TfrmMain.mskSymbolRateChange(Sender: TObject);
begin
  FrontEndChange(Sender);
end;


procedure TfrmMain.tmrUpdateTimer(Sender: TObject);
var
  Result    : Integer;
  Status    : Integer;
  Noise     : Word;
  StatusStr : string;
  Strength  : Word;
begin
  txtPacketCount.Caption := format('%5.5d %5.5d %5.5d %5.5d %5.5d', [Counts, VideoPidCount, AudioPidCOunt, PmtPidCount, PatPidCount]);
{$IFDEF USEDLL}
  Result := FrontEndIoCtl(FrontEndHandle, FE_READ_SIGNAL_STRENGTH, @Strength);
{$ELSE}
  Result := UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_READ_SIGNAL_STRENGTH, @Strength);
{$ENDIF}
  if Result >= 0 then
  begin
    txtSignalPower.Caption := format('%d', [Strength]);
    ggPower.Progress := Round((Strength * 100)/65536);
  end;

{$IFDEF USEDLL}
  Result := FrontEndIoCtl(FrontEndHandle, FE_READ_STATUS, @Status);
{$ELSE}
  Result := UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_READ_STATUS, @Status);
{$ENDIF}
  if Result >= 0 then
  begin
    if (Status and FE_HAS_SIGNAL) <> 0 then
      StatusStr := 'SIGNAL'
    else
      StatusStr := 'NO SIGNAL';
    if (Status and FE_HAS_CARRIER) <> 0 then
      StatusStr := StatusStr + ' - CARRIER'
    else
      StatusStr := StatusStr + ' - NO CARRIER';
    if (Status and FE_HAS_VITERBI) <> 0 then
      StatusStr := StatusStr + ' - FEC STABLE'
    else
      StatusStr := StatusStr + ' - FEC INSTABLE';
    if (Status and FE_HAS_SYNC) <> 0 then
      StatusStr := StatusStr + ' - SYNC'
    else
      StatusStr := StatusStr + ' - NO SYNC';
    txtSignalState.Caption := StatusStr;
    if (Status and (FE_HAS_SIGNAL or FE_HAS_CARRIER or FE_HAS_VITERBI or FE_HAS_SYNC)) =
                   (FE_HAS_SIGNAL or FE_HAS_CARRIER or FE_HAS_VITERBI or FE_HAS_SYNC) then
    begin
      ggPower.ForeColor := clLime;
      ggNoise.ForeColor := clLime;
    end
    else
    begin
      ggPower.ForeColor := clRed;
      ggNoise.ForeColor := clRed;
    end;
  end;
{$IFDEF USEDLL}
  Result := FrontEndIoCtl(FrontEndHandle, FE_READ_SNR, @Noise);
{$ELSE}
  Result := UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_READ_SNR, @Noise);
{$ENDIF}
  if Result >= 0 then
  begin
    txtNoiseIndicator.Caption := format('%d', [Noise]);
    ggNoise.Progress := Round((Noise * 100)/65536);
  end;
end;


procedure TfrmMain.mskFrequencyChange(Sender: TObject);
begin
  FrontEndChange(Sender);
end;


procedure TfrmMain.mskFrequencyKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    mskFrequencyChange(nil);
end;


procedure TfrmMain.mskSymbolRateKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    mskSymbolrateChange(nil);
end;


procedure TfrmMain.mskPidKeyPress(Sender: TObject; var Key: Char);
begin
  if Key = #13 then
    mskPidChange(nil);
end;


procedure TfrmMain.mskPidChange(Sender: TObject);
var
  Error          : Integer;
  PidVideo       : Integer;
  PidAudio       : Integer;
  PidPmt         : Integer;
  DmxBackDoorFeed: TDmxbackDoorFeed;
begin
  Val(mskVideoPid.EditText, PidVideo, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Could not convert Video PID.');
    Exit;
  end;
  Val(mskAudioPid.EditText, PidAudio, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Could not convert Audio PID.');
    Exit;
  end;
  Val(mskPmtPid.EditText, PidPmt, Error);
  if Error <> 0 then
  begin
    mmoDriver.Lines.Add('Could not convert PMT PID.');
    Exit;
  end;

  if PidVideo <> VideoPid then
  begin
    // Remove old PID if changed
    DmxBackDoorFeed.Pid := VideoPid;
    DemuxIoCtl(0, DMX_BACKDOOR_STOP_FEED, @DmxBackDoorFeed);
  end;
  // Set new PID
  VideoPid := PidVideo;
  DmxBackDoorFeed.Pid := VideoPid;
  if DemuxIoCtl(0, DMX_BACKDOOR_START_FEED, @DmxBackDoorFeed) < 0then
    mmoDriver.Lines.Add('Feed start error');
//  else
//    mmoDriver.Lines.Add(format('PID %d set.', [DmxBackDoorFeed.Pid]));
  if PidAudio <> AudioPid then
  begin
    // Remove old PID if changed
    DmxBackDoorFeed.Pid := AudioPid;
    DemuxIoCtl(0, DMX_BACKDOOR_STOP_FEED, @DmxBackDoorFeed);
  end;
  // Set new PID
  AudioPid := PidAudio;
  DmxBackDoorFeed.Pid := AudioPid;
  if DemuxIoCtl(0, DMX_BACKDOOR_START_FEED, @DmxBackDoorFeed) < 0 then
    mmoDriver.Lines.Add('Feed start error');
//  else
//    mmoDriver.Lines.Add(format('PID %d set.', [DmxBackDoorFeed.Pid]));
  // For DirectShow we also need the PMT data
  if PidPmt <> PmtPid then
  begin
    // Remove old PID if changed
    DmxBackDoorFeed.Pid := PmtPid;
    DemuxIoCtl(0, DMX_BACKDOOR_STOP_FEED, @DmxBackDoorFeed);
  end;
  // Set new PID
  PmtPid := PidPmt;
  DmxBackDoorFeed.Pid := PmtPid;
  if DemuxIoCtl(0, DMX_BACKDOOR_START_FEED, @DmxBackDoorFeed) < 0 then
    mmoDriver.Lines.Add('Feed start error');
//  else
//    mmoDriver.Lines.Add(format('PID %d set.', [DmxBackDoorFeed.Pid]));

  // We always need toPAT PID
  DmxBackDoorFeed.Pid := 0;
  if DemuxIoCtl(0, DMX_BACKDOOR_START_FEED, @DmxBackDoorFeed) < 0 then
    mmoDriver.Lines.Add('Feed start error');
//  else
//    mmoDriver.Lines.Add(format('PID %d set.', [DmxBackDoorFeed.Pid]));

  DirectShowMpeg2DemultiplexerSetNewPids(VideoPid, AudioPid);
end;



procedure TfrmMain.SatSelect(Sender: TObject; Satellite: Integer);
var
  Result : Integer;
  DiSEqC : TDvbDiSEqCMasterCmd;
  Repeats: Integer;
begin
  DiSEqC.Msg[0] := $E0;                                    // Framing: Command from master, no reply required, first transmission
  DiSEqC.Msg[1] := $10;                                    // Address: Any LNB/switcher
  DiSEqC.Msg[2] := $38;                                    // Command: Committed sitches (DiSEqc level 1.0)
  case Satellite of
    0:   DiSEqC.Msg[3] := $F0;                             // Data   : Switch ID in low nibble
    1:   DiSEqC.Msg[3] := $F8;                             // Data   : Switch ID in low nibble
    2:   DiSEqC.Msg[3] := $F4;                             // Data   : Switch ID in low nibble
    3:   DiSEqC.Msg[3] := $FC;                             // Data   : Switch ID in low nibble
    else DiSEqC.Msg[3] := $F0;                             // Data   : Switch ID in low nibble
  end;
  DiSEqC.MsgLen := 4;
  Repeats := CmbRepeats.ItemIndex;
  repeat
  {$IFDEF USEDLL}
    Result := FrontEndIoCtl(FrontEndHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ELSE}
    Result := UFlexCopFrontEnd.IoCtl(FrontEndHandle, FE_DISEQC_SEND_MASTER_CMD, @DiSEqC);
  {$ENDIF}
    if Result < 0 then
      mmoDriver.Lines.Add(format('Unable to send DiSEqC master command. Error code %d.', [Result]));
    DiSEqC.Msg[0] := $E1;                                  // Framing: Command from master, no reply required, repeated transmission
    if Repeats >= 0 then
      Sleep(100);                                          // When there is a repeated command we need a 100 ms delay in between
    Dec(Repeats);
  until Repeats < 0;
end;



procedure TfrmMain.btnSat1Click(Sender: TObject);
begin
  SatSelect(Sender, 0);
end;

procedure TfrmMain.btnSat2Click(Sender: TObject);
begin
  SatSelect(Sender, 1);
end;

procedure TfrmMain.btnSat3Click(Sender: TObject);
begin
  SatSelect(Sender, 2);
end;

procedure TfrmMain.btnSat4Click(Sender: TObject);
begin
  SatSelect(Sender, 3);
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Initialize;
var
  Result    : Integer;
begin
  ShowVideo     := False;
  AudioPid      := 0;
  VideoPid      := 0;
  PmtPid        := 0;
  AudioPidCount := 0;
  VideoPidCount := 0;
  PmtPidCount   := 0;
  PatPidCount   := 0;
  Counts        := 0;
  FrontEndDllHandle := 0;
  DemuxDllHandle    := 0;
  FrontEndHandle    := INVALID_HANDLE_VALUE;

{$IFDEF USEDLL}
  FrontEndDllHandle := LoadLibrary(PChar(ExtractFilepath(Application.ExeName)+'FlexCopFrontEnd.dll'));
  if FrontEndDllHandle = 0 then
    ShowMessage(format('LoadLibrary(%s): failed',['FlexCopFrontEnd.dll']));

  FrontEndOpen := GetProcAddress(FrontEndDllHandle,'Open');
  if not Assigned(@FrontEndOpen) then
  begin
    ShowMessage(format('GetProcAddress(%s): failed',['Open']));
    Application.Terminate;
  end;

  FrontEndClose := GetProcAddress(FrontEndDllHandle,'Close');
  if not Assigned(@FrontEndClose) then
  begin
    ShowMessage(format('GetProcAddress(%s): failed',['Close']));
    Application.Terminate;
  end;

  FrontEndIoCtl := GetProcAddress(FrontEndDllHandle,'IoCtl');
  if not Assigned(@FrontEndIoCtl) then
  begin
    ShowMessage(format('GetProcAddress(%s): failed',['IoCtl']));
    Application.Terminate;
  end;
{$ENDIF}
  DemuxDllHandle := LoadLibrary(PChar(ExtractFilepath(Application.ExeName)+'FlexCopDemux.dll'));
  if DemuxDllHandle = 0 then
  begin
    ShowMessage(format('LoadLibrary(%s): failed',['FlexCopDemux.dll']));
    Application.Terminate;
  end;
  DemuxIoCtl := GetProcAddress(DemuxDllHandle,'IoCtl');
  if not Assigned(@DemuxIoCtl) then
  begin
    ShowMessage(format('GetProcAddress(%s): failed',['IoCtl']));
    Application.Terminate;
  end;

{$IFDEF USEDLL}
  Result := FrontEndOpen('frontend0'#0, 0);
{$ELSE}
  Result := UFlexCopFrontEnd.Open('frontend0'#0, 0);
{$ENDIF}
  if Result <= 0 then
  begin
    ShowMessage('Getting handle for frontend failed [FlexCopFrontEnd.dll]');
    Application.Terminate;
  end
  else
    FrontEndHandle := Result;
  DemuxIoCtl(0, DMX_REGISTER_CALLBACK, @DataCallback);
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Finalize
  Notes   :
 ------------------------------------------------------------------------------}
procedure Finalize;
begin
{$IFDEF USEDLL}
  if FrontEndDllHandle <> 0 then
  begin
    if FrontEndHandle <> INVALID_HANDLE_VALUE then
      FrontEndClose(FrontEndHandle);
    FreeLibrary(FrontEndDllHandle);
  end;
{$ENDIF}
  if DemuxDllHandle <> 0 then
  begin
    DemuxIoCtl(0, DMX_REGISTER_CALLBACK, nil);
    FreeLibrary(DemuxDllHandle);
  end;
end;

initialization
  Initialize;


finalization
  Finalize;
end.
