{******************************************************************************}
{ FileName............: FlexCopFrontEndDefines                                 }
{ Project.............:                                                        }
{ Author(s)...........: MM                                                     }
{ Version.............: 1.00                                                   }
{------------------------------------------------------------------------------}
{  Linux DVB Api Version 3 front end defines.                                  }
{                                                                              }
{  Copyright (C) 2003-2005  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  1.00   20050416 - Initial release                                           }
{******************************************************************************}
unit FlexCopFrontEndDefines;


interface


type
  // Types for dynamically loading the DLL
  TFlexCopOpen  = function(const DeviceName: PChar; const Flags: Integer): Integer; stdcall;
  TFlexCopClose = function(const FileDescriptor: Integer): Integer; stdcall;
  TFlexCopIoCtl = function(const FileDescriptor: Integer; const Request: Integer; Parameter: Pointer): Integer;  stdcall;

const
  // Error codes
  ENOERROR       = Integer(0);                   // No error
  EPERM          = Integer(1);                   // Operation not permitted
  EBADF          = Integer(9);                   // Bad file number
  EFAULT         = Integer(14);                  // Bad address
  ENODEV         = Integer(19);                  // No such device
  EINVAL         = Integer(22);                  // Invalid argument
  ENOSYS         = Integer(38);                  // Function not implemented
  EOPNOTSUPP     = Integer(95);                  // Operation not supported on transport endpoint


  // Front end type
  FE_QPSK = Integer(0);
  FE_QAM  = Integer(1);
  FE_OFDM = Integer(2);

  // Front end capabilities
  FE_IS_STUPID                  = Integer($00000000);
  FE_CAN_INVERSION_AUTO         = Integer($00000001);
  FE_CAN_FEC_1_2                = Integer($00000002);
  FE_CAN_FEC_2_3                = Integer($00000004);
  FE_CAN_FEC_3_4                = Integer($00000008);
  FE_CAN_FEC_4_5                = Integer($00000010);
  FE_CAN_FEC_5_6                = Integer($00000020);
  FE_CAN_FEC_6_7                = Integer($00000040);
  FE_CAN_FEC_7_8                = Integer($00000080);
  FE_CAN_FEC_8_9                = Integer($00000100);
  FE_CAN_FEC_AUTO               = Integer($00000200);
  FE_CAN_QPSK                   = Integer($00000400);
  FE_CAN_QAM_16                 = Integer($00000800);
  FE_CAN_QAM_32                 = Integer($00001000);
  FE_CAN_QAM_64                 = Integer($00002000);
  FE_CAN_QAM_128                = Integer($00004000);
  FE_CAN_QAM_256                = Integer($00008000);
  FE_CAN_QAM_AUTO               = Integer($00010000);
  FE_CAN_TRANSMISSION_MODE_AUTO = Integer($00020000);
  FE_CAN_BANDWIDTH_AUTO         = Integer($00040000);
  FE_CAN_GUARD_INTERVAL_AUTO    = Integer($00080000);
  FE_CAN_HIERARCHY_AUTO         = Integer($00100000);
  FE_CAN_RECOVER                = Integer($20000000);
  FE_CAN_CLEAN_SETUP            = Integer($40000000);
  FE_CAN_MUTE_TS                = Integer($80000000);


type
  PDvbFrontEndInfo = ^TDvbFrontEndInfo;
  TDvbFrontEndInfo = record
    Name               : array[0..127] of Char;
    FeType             : Integer;
    FrequencyMin       : Integer;
    FrequencyMax       : Integer;
    FrequencyStepSize  : Integer;
    FrequencyTolerance : Integer;
    SymbolRateMin      : Integer;
    SymbolRateMax      : Integer;
    SymbolRateTolerance: Integer;
    NotifierDelay      : Integer;
    Capabilities       : Integer;
  end;

  PDvbDiSEqCMasterCmd = ^TDvbDiSEqCMasterCmd;
  TDvbDiSEqCMasterCmd = packed record
    Msg   : array[0..5] of Byte;                 // Framing, address, command, data1/2/3
    MsgLen: Byte;                                // Length
  end;

  PDvbDiSEqCSlaveReply = ^TDvbDiSEqCSlaveReply;
  TDvbDiSEqCSlaveReply = packed record
    Msg    : array[0..3] of Byte;                // Framing, data1/2/3
    MsgLen : Byte;                               // Length (0 = no message)
    TimeOut: Integer;                            // Timeout in ms
  end;


const
  // SEC voltage
  SEC_VOLTAGE_13 = Integer(0);
  SEC_VOLTAGE_18 = Integer(1);

  // SEC tone mode
  SEC_TONE_ON  = Integer(0);
  SEC_TONE_OFF = Integer(1);

  // SEC mini command
  SEC_MINI_A = Integer(0);
  SEC_MINI_B = Integer(1);

  // Front end status
  FE_HAS_SIGNAL  = Integer($01);                 // Found something above the noise level
  FE_HAS_CARRIER = Integer($02);                 // Found a DVB signal
  FE_HAS_VITERBI = Integer($04);                 // FEC is stable
  FE_HAS_SYNC    = Integer($08);                 // Found sync bytes
  FE_HAS_LOCK    = Integer($10);                 // Everything's working...
  FE_TIMEDOUT    = Integer($20);                 // No lock within the last ~2 seconds
  FE_REINIT      = Integer($40);                 // Frontend was reinitialized, application is
                                                 // recommended to reset DiSEqC, tone and parameters
  // Spectral inversion
  INVERSION_OFF  = Integer(0);
  INVERSION_ON   = Integer(1);
  INVERSION_AUTO = Integer(2);

  // Forward error correction code rate
  FEC_NONE = Integer(0);
  FEC_1_2  = Integer(1);
  FEC_2_3  = Integer(2);
  FEC_3_4  = Integer(3);
  FEC_4_5  = Integer(4);
  FEC_5_6  = Integer(5);
  FEC_6_7  = Integer(6);
  FEC_7_8  = Integer(7);
  FEC_8_9  = Integer(8);
  FEC_AUTO = Integer(9);


type
  PDvbQpskParameters = ^TDvbQpskParameters;
  TDvbQpskParameters = packed record
    SymbolRate: Integer;                         // Symbol rate in Symbols per second
    FecInner  : Integer;                         // Forward error correction
  end;


const
  // Modulation type
  QPSK     = Integer(0);
  QAM_16   = Integer(1);
  QAM_32   = Integer(2);
  QAM_64   = Integer(3);
  QAM_128  = Integer(4);
  QAM_256  = Integer(5);
  QAM_AUTO = Integer(6);


type
  PDvbQamParameters = ^TDvbQamParameters;
  TDvbQamParameters = packed record
    SymbolRate: Integer;                         // Symbol rate in Symbols per second
    FecInner  : Integer;                         // Forward error correction
    Modulation: Integer;                         // Modulation type
  end;


const
  // Band width
  BANDWIDTH_8_MHZ = Integer(0);
  BANDWIDTH_7_MHZ = Integer(1);
  BANDWIDTH_6_MHZ = Integer(2);
  BANDWIDTH_AUTO  = Integer(3);

  // Transmission mode
  TRANSMISSION_MODE_2K   = Integer(0);
  TRANSMISSION_MODE_8K   = Integer(1);
  TRANSMISSION_MODE_AUTO = Integer(2);

  // Guard interval
  GUARD_INTERVAL_1_32 = Integer(0);
  GUARD_INTERVAL_1_16 = Integer(1);
  GUARD_INTERVAL_1_8  = Integer(2);
  GUARD_INTERVAL_1_4  = Integer(3);
  GUARD_INTERVAL_AUTO = Integer(4);

  // Hierarchy information
  HIERARCHY_NONE = Integer(0);
  HIERARCHY_1    = Integer(1);
  HIERARCHY_2    = Integer(2);
  HIERARCHY_4    = Integer(3);
  HIERARCHY_AUTO = Integer(4);


type
  PDvbOfdmParameters = ^TDvbOfdmParameters;
  TDvbOfdmParameters = packed record
    BandWidth           : Integer;
    CodeRateHp          : Integer;               // High priority stream code rate
    CodeRateLp          : Integer;               // Low priority stream code rate
    Constellation       : Integer;               // Modulation type
    TransmissionMode    : Integer;
    GuardInterval       : Integer;
    HierarchyInformation: Integer;
  end;

  PDvbFrontEndParameters = ^TDvbFrontEndParameters;
  TDvbFrontEndParameters = packed record
    Frequency : Integer;                         // (absolute) frequency in Hz for QAM/OFDM
                                                 // intermediate frequency in kHz for QPSK
    Inversion : Integer;
    case Integer of
      0: (Qpsk: TDvbQpskParameters);
      1: (Qam : TDvbQamParameters);
      2: (Ofdm: TDvbOfdmParameters);
  end;

  PDvbFrontEndEvent = ^TDvbFrontEndEvent;
  TDvbFrontEndEvent = packed record
    Status    : Integer;
    Parameters: TDvbFrontEndParameters;
  end;


const
  FE_GET_INFO                = Integer($80A86F3D);
  FE_DISEQC_RESET_OVERLOAD   = Integer($00006F3E);
  FE_DISEQC_SEND_MASTER_CMD  = Integer($40076F3F);
  FE_DISEQC_RECV_SLAVE_REPLY = Integer($800C6F40);
  FE_DISEQC_SEND_BURST       = Integer($00006F41);
  FE_SET_TONE                = Integer($00006F42);
  FE_SET_VOLTAGE             = Integer($00006F43);
  FE_ENABLE_HIGH_LNB_VOLTAGE = Integer($00006F44);
  FE_READ_STATUS             = Integer($80046F45);
  FE_READ_BER                = Integer($80046F46);
  FE_READ_SIGNAL_STRENGTH    = Integer($80026F47);
  FE_READ_SNR                = Integer($80026F48);
  FE_READ_UNCORRECTED_BLOCKS = Integer($80046F49);
  FE_SET_FRONTEND            = Integer($40246F4C);
  FE_GET_FRONTEND            = Integer($80246F4D);
  FE_GET_EVENT               = Integer($80286F4E);


  CStv0299bCrystalFrequency      = 4000000;                // 4 MHz
  CStv0299bVcoMFactor            = 21;
  CStv0299bVcoKFactor            = 0;
  CStv0299bVcoPFactor            = 0;
  CStv0299bVcoPDivider           = 4;                      // 4, 6, 8, 12, 16, 24, 32, 48
  CStv0299bVco                   =
    CStv0299bCrystalFrequency * 4 * ((CStv0299bVcoMFactor + 1) div
                                     (CStv0299bVcoKFactor + 1));
  CStv0299bMasterClock           =
    CStv0299bVco div CStv0299bVcoPDivider;
    
  Stv0299bDvbFrontEndInfo : TDvbFrontEndInfo =
     ( Name               : 'STV0299/SL1935 based';
       FeType             : FE_QPSK;
       FrequencyMin       : 950000;
       FrequencyMax       : 2150000;
       FrequencyStepSize  : 125;
       FrequencyTolerance : CStv0299bMasterClock div 2000;
       SymbolRateMin      : 1000000;
       SymbolRateMax      : 45000000;
       SymbolRateTolerance: 500;
       NotifierDelay      : 0;
       Capabilities       : FE_CAN_FEC_1_2  or FE_CAN_FEC_2_3 or FE_CAN_FEC_3_4 or
                            FE_CAN_FEC_5_6  or FE_CAN_FEC_7_8 or
                            FE_CAN_QPSK     or
                            FE_CAN_FEC_AUTO or
                            FE_CAN_CLEAN_SETUP);

implementation


end.
