//{******************************************************************************}
//{ FileName............: FlexCopIoControl                                       }
//{ Project.............: FLEXCOP                                                }
//{ Author(s)...........: MM                                                     }
//{ Version.............: 1.00                                                   }
//{------------------------------------------------------------------------------}
//{  I/O control definitions for the FLEXCOP driver                              }
//{                                                                              }
//{  Copyright (C) 2003-2005  M.Majoor                                           }
//{                                                                              }
//{  This program is free software; you can redistribute it and/or               }
//{  modify it under the terms of the GNU General Public License                 }
//{  as published by the Free Software Foundation; either version 2              }
//{  of the License, or (at your option) any later version.                      }
//{                                                                              }
//{  This program is distributed in the hope that it will be useful,             }
//{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
//{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
//{  GNU General Public License for more details.                                }
//{                                                                              }
//{  You should have received a copy of the GNU General Public License           }
//{  along with this program; if not, write to the Free Software                 }
//{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
//{                                                                              }
//{------------------------------------------------------------------------------}
//{                                                                              }
//{ Version   Date   Comment                                                     }
//{  1.00   20050413 - Initial release FLEXCOP.SYS V1.00                         }
//{******************************************************************************}


#ifndef FlexCopIoControl_h
  #define FlexCopIoControl_


/* ------------------------------------------------------------------------------
                               From WDM.H
   ------------------------------------------------------------------------------ */
  #define CTL_CODE( DeviceType, Function, Method, Access ) (                 \
      ((DeviceType) << 16) | ((Access) << 14) | ((Function) << 2) | (Method) \
  )
  #define FILE_DEVICE_UNKNOWN             0x00000022
  #define FILE_ANY_ACCESS                 0
  #define METHOD_BUFFERED                 0
/* ------------------------------------------------------------------------------
                               End WDM.H
   ------------------------------------------------------------------------------ */


  typedef LARGE_INTEGER PHYSICAL_ADDRESS, *PPHYSICAL_ADDRESS;

  typedef struct _TFlexCopWriteRegister
  {
    ULONG   Address;                                       // Address to write to
    ULONG   Data;                                          // Data to write
  } TFlexCopWriteRegister, *PTFlexCopWriteRegister;


  typedef struct _TFlexCopWriteWord
  {
    ULONG   Address;                                       // Address to write to
    USHORT  Data;                                          // Data to write
  } TFlexCopWriteWord, *PTFlexCopWriteWord;


  typedef struct _TFlexCopGetDriverVersion
  {
    USHORT  MajorVersion;                                  // Major version
    USHORT  MinorVersion;                                  // Minor version
    ULONG   Build;                                         // Build (date) -> $YYYYMMDD
  } TFlexCopGetDriverVersion, *PTFlexCopGetDriverVersion;


  typedef struct _TFlexCopGetDmaStatus
  {
    ULONG            Interrupts;                           // Interrupts occured
    ULONG            Isr;                                  // Interrupt status register of last interrupt
    PVOID            VirtualAddress;                       // Virtual address DMA buffer
    PHYSICAL_ADDRESS PhysicalAddress;                      // Physical address DMA buffer
    ULONG            Size;                                 // Size of DMA buffer (in bytes)
    ULONG            FifoOverflows;                        // Global FIFO overflows
  } TFlexCopGetDmaStatus, *PTFlexCopGetDmaStatus;

  typedef struct _TFlexCopDmaBuffer
  {
    LONG             Identifier;                           // ID of buffer
    PVOID            VirtualAddress;                       // Virtual address of buffer
    PHYSICAL_ADDRESS PhysicalAddress;                      // Physical address of buffer
    ULONG            Size;                                 // Size of buffer
  } TFlexCopDmaBuffer, *PTFlexCopDmaBuffer;


  typedef struct _TFlexCopTransferBuffer
  {
    LONG             Identifier;                           // Identification of buffer
    PUCHAR           TransferAddress;                      // Transfer buffer (source/target)
    ULONG            SourceIndex;                          // Source transfer index in buffer
    ULONG            TargetIndex;                          // Target transfer index in buffer
    ULONG            TransferLength;                       // Transfer length
  } TFlexCopTransferBuffer, *PTFlexCopTransferBuffer;

  typedef struct _TFlexCopFifoTransferBuffer
  {
    LONG             Identifier;                           // Identification of FIFO buffer (<0 means not in use)
    LONG             NumberOfBuffers;                      // Number of buffers
    PVOID            TransferAddress[2];                   // Pointer to source buffer for each interrupt (sub buffer 0/1)
    ULONG            TransferLength;                       // Transfer length (buffer sizes)
    BOOLEAN          IsValid;                              // Copy of <writeTag> indicating buffer has been written to
    ULONG            OrderNumber;                          // Copy of <irqsActiveReceived> counter when FIFO was written = order number
    ULONG            Overflows;                            // Counter incremented when written to buffer with <writeTag> TRUE
    ULONG            Irqs;                                 // Counter incremented for each interrupt associated with the FIFO
    ULONG            AllOverflows;                         // Counter incremented when written to buffer with <writeTag> TRUE for ALL FIFO buffers of the associated IRQ
  } TFlexCopFifoTransferBuffer, *PTFlexCopFifoTransferBuffer;

  typedef struct _TFlexCopIrqBuffer
  {
    ULONG            Irqs;                                 // Counter incremented for each interrupt of this type
    ULONG            IrqsWhenActive;                       // Counter incremented for each interrupt of this type when active
    BOOLEAN          IrqBufferingIsActive;                 // Global activation flag of the interrupt
    BOOLEAN          UseNotificationEvent;                 // Indicates notify event to be triggered
    BOOLEAN          UseSignaling;                         // Indicates signal to be triggered
    BOOLEAN          UseFifo;                              // Indicates FIFO to be used
    BOOLEAN          Reserved;                             // Not used

    ULONG            SignalFlexCopRegister;                // FLEXCOP register to read and write back for banking info
    ULONG            SignalAndValue;                       // AND operation to perform on register contents to extract bit
    ULONG            SignalOrValue;                        // OR  peration to perform on ANDED register contents to extract bit
    ULONG            SignalXorValue;                       // XOR (invert) operation to perform on ANDED and ORED register contents to write bit

    UCHAR            FifoBufferPreviousIndex;              // Previous FIFO used (index FIFO buffer array)
    UCHAR            FifoBufferFirstIndex;                 // First FIFO to use (index FIFO buffer array)
    UCHAR            FifoBufferLastIndex;                  // Last  FIFO to use (index FIFO buffer array)
    ULONG            FifoBufferCirculations;               // Counter incremented each time <fifoBufferNext> == <fifoBufferStart>
    ULONG            FifoOverflows;                        // Counter incremented each time a FIFO <writeTag> was still set when written to it
  } TFlexCopIrqBuffer, *PTFlexCopIrqBuffer;

  typedef struct _TFlexCopIrqTransferBuffer
  {
    LONG               Identifier;                         // ID of FlexCop IRQ bit number (0..31)
    TFlexCopIrqBuffer Information;                        // Information structure
  } TFlexCopIrqTransferBuffer, *PTFlexCopIrqTransferBuffer;


/* ------------------------------------------------------------------------------
    Descript: IOCTL codes to access driver.
   ----------------------------------------------------------------------------- */
  #define CIoctlFlexCopGetDriverVersion            CTL_CODE(FILE_DEVICE_UNKNOWN, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS) // Retrieve version information (FlexCop_GET_VERSION structure)
  #define CIoctlFlexCopGetDmaStatus                CTL_CODE(FILE_DEVICE_UNKNOWN, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS) // Retrieve status information  (FlexCop_GET_STATUS  structure)
  #define CIoctlFlexCopReadFromFlexCopRegister     CTL_CODE(FILE_DEVICE_UNKNOWN, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read  a FlexCop register
  #define CIoctlFlexCopWriteToFlexCopRegister      CTL_CODE(FILE_DEVICE_UNKNOWN, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS) // Write a FlexCop register
  #define CIoctlFlexCopWaitForNotification         CTL_CODE(FILE_DEVICE_UNKNOWN, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS) // Wait for a notification
  #define CIoctlFlexCopGenerateManualNotification  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS) // Manually trigger the notification
  #define CIoctlFlexCopAllocateDma                 CTL_CODE(FILE_DEVICE_UNKNOWN, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS) // Allocate  DMA buffer
  #define CIoctlFlexCopReleaseDma                  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS) // Release   DMA buffer
  #define CIoctlFlexCopReadFromDma                 CTL_CODE(FILE_DEVICE_UNKNOWN, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read from DMA buffer
  #define CIoctlFlexCopWriteToDma                  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x809, METHOD_BUFFERED, FILE_ANY_ACCESS) // Write to  DMA buffer
  #define CIoctlFlexCopAllocateFifo                CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80A, METHOD_BUFFERED, FILE_ANY_ACCESS) // Allocate  FIFO buffer
  #define CIoctlFlexCopReleaseFifo                 CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80B, METHOD_BUFFERED, FILE_ANY_ACCESS) // Release   FIFO buffer
  #define CIoctlFlexCopReadFromFifo                CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80C, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read from FIFO buffer
  #define CIoctlFlexCopWriteToIrqHandling          CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80D, METHOD_BUFFERED, FILE_ANY_ACCESS) // Write to  IRQ handling
  #define CIoctlFlexCopReadFromIrqHandling         CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80E, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read from IRQ handling
  #define CIoctlFlexCopReadFromFlexCopRegister2    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80F, METHOD_BUFFERED, FILE_ANY_ACCESS) // Read  a FlexCop register (word)
  #define CIoctlFlexCopWriteToFlexCopRegister2     CTL_CODE(FILE_DEVICE_UNKNOWN, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS) // Write a FlexCop register (word

#endif
