//{ **************************************************************************** }
//{ FileName............: IOCTLS.H                                               }
//{ Project.............: FLEXCOP                                                }
//{ Author(s)...........: M.Majoor                                               }
//{ Original contents...: Walter Oney ('Programming the Windows Driver Model')   }
//{ Version.............: 3.20                                                   }
//{ ---------------------------------------------------------------------------- }
//{ IOCTL code definitions for FLEXCOP driver.                                   }
//{                                                                              }
//{ Version  Date      Comment                                                   }
//{ 1.00     20050410  - Initial release based on SAA7146A driver V2.02          }
//{ 2.00     20060722  - Changes for 64-bit driver being called by 32-bit        }
//{                      application                                             }
//{ 2.10     20080126  - No changes                                              }
//{ 3.20     20171213  - Initialization values and macros added to prevent       }
//{                      compiler warnings                                       }
//{ **************************************************************************** }


#ifndef IOCTLS_H
  #define IOCTLS_H

  #ifndef CTL_CODE
    #pragma message("CTL_CODE undefined. Include winioctl.h or wdm.h")
  #endif

  // Structure used for returning version information
  typedef struct _GETVERSION
  {
    USHORT  majorversion;                                  // Major version
    USHORT  minorversion;                                  // Minor version
    ULONG   build;                                         // Build (date) -> $YYYYMMDD
  } GETVERSION, *PGETVERSION;

  // Structure used for writing data to FLEXCOP (dword access)
  typedef struct _FLEXCOPWRITE
  {
    ULONG   address;                                       // Address to write to
    ULONG   data;                                          // Data to write
  } FLEXCOPWRITE, *PFLEXCOPWRITE;

  // Structure used for writing data to FLEXCOP (word access)
  typedef struct _FLEXCOPWRITE2
  {
    ULONG   address;                                       // Address to write to
    USHORT  data;                                          // Data to write
  } FLEXCOPWRITE2, *PFLEXCOPWRITE2;

 // Structure used for returning status information (native size: 32 or 64-bit)
  typedef struct _GETSTATUS_NATIVE
  {
    ULONG            interrupts;                           // Interrupts occured
    ULONG            isr;                                  // Interrupt status register of last interrupt
    PVOID            vaBuffer;                             // Virtual address DMA buffer
    PHYSICAL_ADDRESS paBuffer;                             // Physical address DMA buffer
    ULONG            buffersize;                           // Size of DMA buffer (in bytes)
    ULONG            fifoOverflows;                        // Global FIFO overflows
  } GETSTATUS_NATIVE, *PGETSTATUS_NATIVE;

  // Structure used for returning status information (32-bit)
  typedef struct _GETSTATUS_32
  {
    ULONG            interrupts;                           // Interrupts occured
    ULONG            isr;                                  // Interrupt status register of last interrupt
    VOID*POINTER_32  vaBuffer;                             // Virtual address DMA buffer
    PHYSICAL_ADDRESS paBuffer;                             // Physical address DMA buffer
    ULONG            buffersize;                           // Size of DMA buffer (in bytes)
    ULONG            fifoOverflows;                        // Global FIFO overflows
  } GETSTATUS_32, *PGETSTATUS_32;

  // Structure used to pass transfer buffer information (native size: 32 or 64-bit)
  typedef struct _TRANSFERBUFFER_NATIVE
  {
    LONG             bufferId;                             // Identification of buffer
    PUCHAR           bufferTransfer;                       // Transfer buffer (source/target)
    ULONG            bufferSourceIndex;                    // Source transfer index in buffer
    ULONG            bufferTargetIndex;                    // Target transfer index in buffer
    ULONG            bufferTransferLength;                 // Transfer length
  } TRANSFERBUFFER_NATIVE, *PTRANSFERBUFFER_NATIVE;

  // Structure used to pass transfer buffer information (32-bit)
  typedef struct _TRANSFERBUFFER_32
  {
    LONG             bufferId;                             // Identification of buffer
    PUCHAR*POINTER_32 bufferTransfer;                      // Transfer buffer (source/target)
    ULONG            bufferSourceIndex;                    // Source transfer index in buffer
    ULONG            bufferTargetIndex;                    // Target transfer index in buffer
    ULONG            bufferTransferLength;                 // Transfer length
  } TRANSFERBUFFER_32, *PTRANSFERBUFFER_32;

  // Structure used to pass FIFO buffer information (native size: 32 or 64-bit)
  typedef struct _FIFOTRANSFERBUFFER_NATIVE
  {
    LONG             bufferId;                             // Identification of FIFO buffer (<0 means not in use)
    LONG             buffers;                              // Number of buffers
    PVOID            bufferTransfer[2];                    // Transfer buffer (source/target for each sub buffer)
    ULONG            bufferTransferLength;                 // Transfer length (buffer sizes)
    BOOLEAN          bufferWritten;                        // Copy of <writeTag> indicating buffer has been written to
    ULONG            bufferOrder;                          // Copy of <irqsActiveReceived> counter when FIFO was written = order number
    ULONG            bufferOverflows;                      // Counter incremented when written to buffer with <writeTag> TRUE
    ULONG            bufferIrqs;                           // Counter incremented for each interrupt associated with the FIFO
    ULONG            bufferIrqOverflows;                   // Counter incremented when written to buffer with <writeTag> TRUE for ALL FIFO buffers of the associated IRQ
  } FIFOTRANSFERBUFFER_NATIVE, *PFIFOTRANSFERBUFFER_NATIVE;

  // Structure used to pass FIFO buffer information (32-bit)
  typedef struct _FIFOTRANSFERBUFFER_32
  {
    LONG             bufferId;                             // Identification of FIFO buffer (<0 means not in use)
    LONG             buffers;                              // Number of buffers
    VOID*POINTER_32  bufferTransfer[2];                    // Transfer buffer (source/target for each sub buffer)
    ULONG            bufferTransferLength;                 // Transfer length (buffer sizes)
    BOOLEAN          bufferWritten;                        // Copy of <writeTag> indicating buffer has been written to
    ULONG            bufferOrder;                          // Copy of <irqsActiveReceived> counter when FIFO was written = order number
    ULONG            bufferOverflows;                      // Counter incremented when written to buffer with <writeTag> TRUE
    ULONG            bufferIrqs;                           // Counter incremented for each interrupt associated with the FIFO
    ULONG            bufferIrqOverflows;                   // Counter incremented when written to buffer with <writeTag> TRUE for ALL FIFO buffers of the associated IRQ
  } FIFOTRANSFERBUFFER_32, *PFIFOTRANSFERBUFFER_32;

  // Structure used to pass IRQ information
  typedef struct _IRQTRANSFERBUFFER
  {
    LONG             IrqId;                                // Identification of IRQ (0..31)
    IRQBUFFER        IrqInformation;                       // Information
  } IRQTRANSFERBUFFER, *PIRQTRANSFERBUFFER;

  #define IOCTL_GET_VERSION    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x800, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_GET_STATUS     CTL_CODE(FILE_DEVICE_UNKNOWN, 0x801, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_FLEXCOP_READ   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x802, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_FLEXCOP_WRITE  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x803, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_WAIT_NOTIFY    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x804, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_GENERATE_EVENT CTL_CODE(FILE_DEVICE_UNKNOWN, 0x805, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_DMA_ALLOCATE   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x806, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_DMA_RELEASE    CTL_CODE(FILE_DEVICE_UNKNOWN, 0x807, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_DMA_READ       CTL_CODE(FILE_DEVICE_UNKNOWN, 0x808, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_DMA_WRITE      CTL_CODE(FILE_DEVICE_UNKNOWN, 0x809, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_FIFO_ALLOCATE  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80A, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_FIFO_RELEASE   CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80B, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_FIFO_READ      CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80C, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_IRQ_WRITE      CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80D, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_IRQ_READ       CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80E, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_FLEXCOP_READ2  CTL_CODE(FILE_DEVICE_UNKNOWN, 0x80F, METHOD_BUFFERED, FILE_ANY_ACCESS)
  #define IOCTL_FLEXCOP_WRITE2 CTL_CODE(FILE_DEVICE_UNKNOWN, 0x810, METHOD_BUFFERED, FILE_ANY_ACCESS)

#endif
