{******************************************************************************}
{ FileName............: MajorDvbPsiUnit003                                     }
{ Project.............: DirectShow                                             }
{ Author(s)...........: MM                                                     }
{ Version.............: 2.01                                                   }
{------------------------------------------------------------------------------}
{  DirectShow PSI parsing filter property page                                 }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  2.00   20040202 - Initial release                                           }
{  2.01   20040312 - Added additional debug information                        }
{******************************************************************************}
unit MajorDvbPsiUnit003;

interface
uses
  BaseClass,
  Classes,
  Controls,
  DirectShow9,
  ExtCtrls,
  Graphics,
  MajorDvbPsiUnit001,
  Messages,
  StdCtrls,
  SysUtils,
  Windows;

type
  TfrmPropertiesAbout = class(TFormPropertyPage)
    Image1: TImage;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    mmoGNU: TMemo;
  private
  public
    function  OnConnect(Unknown: IUnknown): HRESULT; override;
    function  OnDisconnect: HRESULT; override;
    function  OnApplyChanges: HRESULT; override;
  end;

implementation



{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : <Unknown>
  Returns : <Result>

  Descript: On connect property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmPropertiesAbout.OnConnect(Unknown: IUnknown): HRESULT;
const
  Id: TGUID = IID_MajorDvbPsi;
var
  hr       : HRESULT;
  Version  : PChar;
  PsiFilter: IMajorDvbPsi;
begin
  Version := nil;
  hr := Unknown.QueryInterface(Id, PsiFilter);
  if (FAILED(hr)) then
  begin
    PsiFilter := nil;
    Result := E_NOINTERFACE;
    Exit;
  end;
  // Place version information in tab header
  GetMem(Version, 128);
  PsiFilter.GetVersionInformation(Version);
  Caption := 'About';
  FreeMem(Version);
  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>

  Descript: On disconnect property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmPropertiesAbout.OnDisconnect: HRESULT;
begin
  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: On apply changes property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmPropertiesAbout.OnApplyChanges: HRESULT;
begin
  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialization
  Notes   :
 ------------------------------------------------------------------------------}
initialization
  TBCClassFactory.CreatePropertyPage(TfrmPropertiesAbout, CLSID_MajorDvbPsiPropertyPageAbout);
end.

