{******************************************************************************}
{ FileName............: MajorDvbPsiUnit002                                     }
{ Project.............: DirectShow                                             }
{ Author(s)...........: MM                                                     }
{ Version.............: 2.02a                                                  }
{------------------------------------------------------------------------------}
{  DirectShow PSI parsing filter property page                                 }
{                                                                              }
{  Copyright (C) 2003-2004  M.Majoor                                           }
{                                                                              }
{  This program is free software; you can redistribute it and/or               }
{  modify it under the terms of the GNU General Public License                 }
{  as published by the Free Software Foundation; either version 2              }
{  of the License, or (at your option) any later version.                      }
{                                                                              }
{  This program is distributed in the hope that it will be useful,             }
{  but WITHOUT ANY WARRANTY; without even the implied warranty of              }
{  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               }
{  GNU General Public License for more details.                                }
{                                                                              }
{  You should have received a copy of the GNU General Public License           }
{  along with this program; if not, write to the Free Software                 }
{  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. }
{                                                                              }
{------------------------------------------------------------------------------}
{                                                                              }
{ Version   Date   Comment                                                     }
{  2.00   20040202 - Initial release                                           }
{  2.01   20040312 - Added additional debug information                        }
{  2.02   20040316 - Resynchronization changes                                 }
{  2.02a  20040325 - <DvbCreateTables> button added                            }
{******************************************************************************}
unit MajorDvbPsiUnit002;

interface
uses
  BaseClass,
  Classes,
  Controls,
  DirectShow9,
  ExtCtrls,
  Graphics,
  MajorDvbPsiUnit001,
  Messages,
  StdCtrls,
  SysUtils,
  Windows;

type
  TfrmProperties = class(TFormPropertyPage)
    Label3: TLabel;
    lblPrograms: TLabel;
    Label1: TLabel;
    lblPacketErrors: TLabel;
    lblDebugInformation: TLabel;
    Label2: TLabel;
    lblBufferSize: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    lblDebugCountDsFilterIn: TLabel;
    lblDebugCountDsResyncs: TLabel;
    lblDebugCountToPidFilter: TLabel;
    Label7: TLabel;
    lblDebugCountValidSyncs: TLabel;
    Label8: TLabel;
    lblDebugCountPackets: TLabel;
    Label9: TLabel;
    lblDebugCountFalseSyncs: TLabel;
    Label10: TLabel;
    lblValidDataSize: TLabel;
    Image1: TImage;
    grpLatched: TGroupBox;
    mmoLatchedData: TMemo;
    chkEnableLatch: TCheckBox;
    tmrUpdate: TTimer;
    Label11: TLabel;
    btnWriteFile: TButton;
    btnLogOnOff: TButton;
    btnCreateTables: TButton;
    procedure tmrUpdateTimer(Sender: TObject);
    procedure btnWriteFileClick(Sender: TObject);
    procedure btnLogOnOffClick(Sender: TObject);
    procedure btnCreateTablesClick(Sender: TObject);
  private
    PsiFilter: IMajorDvbPsi;
  public
    function  OnConnect(Unknown: IUnknown): HRESULT; override;
    function  OnDisconnect: HRESULT; override;
    function  OnApplyChanges: HRESULT; override;
  end;

implementation

var
  DebugLog: Boolean;

{$R *.DFM}


{------------------------------------------------------------------------------
  Params  : <Unknown>
  Returns : <Result>

  Descript: On connect property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmProperties.OnConnect(Unknown: IUnknown): HRESULT;
const
  Id: TGUID = IID_MajorDvbPsi;
var
  hr     : HRESULT;
  Version: PChar;
begin
  Version := nil;
  hr := Unknown.QueryInterface(Id, PsiFilter);
  if (FAILED(hr)) then
  begin
    PsiFilter := nil;
    Result := E_NOINTERFACE;
    Exit;
  end;
  // Place version information in tab header
  GetMem(Version, 128);
  PsiFilter.GetVersionInformation(Version);
  Caption := Version;
  FreeMem(Version);

  if DebugLog then
    btnLogOnOff.Caption := 'Set debug log OFF'
  else
    btnLogOnOff.Caption := 'Set debug log ON';

  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : <Result>

  Descript: On disconnect property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmProperties.OnDisconnect: HRESULT;
begin
  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: On apply changes property page.
  Notes   :
 ------------------------------------------------------------------------------}
function TfrmProperties.OnApplyChanges: HRESULT;
begin
  Result := NOERROR;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>
  Returns : -

  Descript: Update form.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmProperties.tmrUpdateTimer(Sender: TObject);
const
  CHex : string[16] = '0123456789ABCDEF';
var
  Info       : PChar;
  InfoCopy   : PChar;
  InfoSize   : Word;
  InfoS2     : Word;
  Retries    : Word;
  Loop1      : Word;
  Loop2      : Word;
  OutStr     : string;
  Count      : Word;
  Count2     : Word;
  Count3     : Word;
  Count4     : Word;
  Count5     : Word;
  Count6     : Word;
  Size       : LongWord;
//  InitLoop   : Word;
  CheckIndex : Word;
begin
  if Assigned(PsiFilter) then
  begin
    lblPacketErrors.Caption     := format('%5.5d', [PsiFilter.DvbGetErrors]);
    lblPrograms.Caption         := format('%3.3d', [PsiFilter.DvbGetNumberOfPrograms]);

    PsiFilter.GetDebugCounters(Count, Count2, Count3, Count4, Count5, Count6);
    lblDebugCountDsFilterIn.Caption            := format('%5.5d', [Count]);

    PsiFilter.GetDebugBufferSize(Size);
    lblBufferSize.Caption       := format('%6.6d', [Size]);
    PsiFilter.GetDebugValidDataSize(Size);
    lblValidDataSize.Caption    := format('%6.6d', [Size]);

    lblDebugCountDsResyncs.Caption   := format('%5.5d', [Count2]);
    lblDebugCountPackets.Caption     := format('%5.5d', [Count3]);
    lblDebugCountValidSyncs.Caption  := format('%5.5d', [Count4]);
    lblDebugCountFalseSyncs.Caption  := format('%5.5d', [Count5]);
    lblDebugCountToPidFilter.Caption := format('%5.5d', [Count6]);

    GetMem(Info, 128);
    PsiFilter.GetDebugInformation(Info);
    lblDebugInformation.Caption := Info;
    FreeMem(Info, 128);

    if chkEnableLatch.Checked then
    begin
      // Get required size of buffer and start new latch
      PsiFilter.GetDebugBufferData(InfoSize, nil);
      GetMem(Info, InfoSize);
      InfoCopy := Info;                                   // Work copy
      Retries := 0;
      // We allow max 100 ms for data to be latched
      repeat
        Sleep(10);
        Inc(Retries);
      until ((PsiFilter.GetDebugBufferData(InfoS2, Info) = S_OK) or (Retries = 10));

      // Next is just for debugging of property page (when we don't get any data at
      // the input). Mainly for checking the displaying.
//      for InitLoop := 0 to 511 do
//        PByteArray(InfoCopy)[InitLoop] := Lo(InitLoop);

      // Display latched data
      CheckIndex := 0;
      for Loop1 := 0 to 31 do
      begin
        OutStr :=  mmoLatchedData.Lines[Loop1];
        for Loop2 := 0 to 15 do
        begin
          if Retries = 10 then
          begin
            OutStr[(Loop2 * 3) + 7] := '?';
            OutStr[(Loop2 * 3) + 8] := '?';
          end
          else
          begin
            OutStr[(Loop2 * 3) + 7] := CHex[(Ord(InfoCopy^) div 16) + 1];
            OutStr[(Loop2 * 3) + 8] := CHex[(Ord(InfoCopy^) mod 16) + 1];
          end;
          Inc(CheckIndex);
          if CheckIndex < InfoSize then
            Inc(InfoCopy);
        end;
        mmoLatchedData.Lines[Loop1] := OutStr;
      end;
      FreeMem(Info, InfoSize);
    end;
  end
  else
  begin
    lblPacketErrors.Caption           := '-----';
    lblPrograms.Caption               := '---';

    lblDebugCountDsFilterIn.Caption   := '-----';
    lblBufferSize.Caption             := '------';
    lblValidDataSize.Caption          := '------';
    lblDebugCountDsResyncs.Caption    := '-----';
    lblDebugCountPackets.Caption      := '-----';
    lblDebugCountValidSyncs.Caption   := '-----';
    lblDebugCountFalseSyncs.Caption   := '-----';
    lblDebugCountToPidFilter.Caption  := '-----';

    lblDebugInformation.Caption       := '-';
  end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>
  Returns : -

  Descript: Execute write to file.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmProperties.btnWriteFileClick(Sender: TObject);
begin
  if not Assigned(PsiFilter) then
    Exit;
  PsiFilter.SetDebugWriteBuffer(2);
end;


{------------------------------------------------------------------------------
  Params  : <Sender>
  Returns : -

  Descript: Toggle debug logging.
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmProperties.btnLogOnOffClick(Sender: TObject);
begin
  if not Assigned(PsiFilter) then
    Exit;
  if DebugLog then
  begin
    DebugLog := False;
    PsiFilter.SetDebugSetLog(False);
    btnLogOnOff.Caption := 'Set debug log ON';
  end
  else
  begin
    DebugLog := True;
    PsiFilter.SetDebugSetLog(True);
    btnLogOnOff.Caption := 'Set debug log OFF';
  end;
end;


{------------------------------------------------------------------------------
  Params  : <Sender>
  Returns : -

  Descript: Re(initialize) tables for filtering
  Notes   :
 ------------------------------------------------------------------------------}
procedure TfrmProperties.btnCreateTablesClick(Sender: TObject);
begin
  if not Assigned(PsiFilter) then
    Exit;
  PsiFilter.DvbCreateTables;
end;


{------------------------------------------------------------------------------
  Params  : -
  Returns : -

  Descript: Initialization
  Notes   :
 ------------------------------------------------------------------------------}
initialization
  DebugLog := False;

  TBCClassFactory.CreatePropertyPage(TfrmProperties, CLSID_MajorDvbPsiPropertyPage);
end.

